.hirom on
;.list
.dasm on
.mem 8
.index 16
;.hirom off

;============================================
;       RAM
;============================================

;---------------------------------------------------------
; Equates
;---------------------------------------------------------

UnpackBuffr     EQU     $7E8000
Buff2   EQU     $000500 ; 24-bit address of $1A0 byte buffer
in      EQU     $65
out     EQU     $68
wrkbuf  EQU     $6a
counts  EQU     $6d
blocks  EQU     $4f
bitbufl EQU     $51
bitbufh EQU     $43
bufbits EQU     $55
bitlen  EQU     $57
hufcde  EQU     $59
hufbse  EQU     $5b
temp1   EQU     $5d
temp2   EQU     $5f
temp3   EQU     $61
temp4   EQU     $63
tmptab  EQU     0       ; indexed from Buff2
rawtab  EQU     $20     ; indexed from Buff2
postab  EQU     $a0     ; indexed from Buff2
slntab  EQU     $120    ; indexed from Buff2


;---------------------------------------------------------

;destn_buf       = $7F0000

test_lo = $00
test_hi = $01
temp_lo = $02
temp_hi = $03
addr_lo = $04
addr_hi = $05
joy1    = $06   ;word
joy1old = $08   ;word
temp_long = $0A ; 3 bytes
sentcount = $0D
sizecount_lo = $0E
sizecount_hi = $0F
song         = $10
load_addy       = $11   ; word
init_lo         = $7F1013
init_hi         = $7F1014
play_lo         = $7F1015
play_hi         = $7F1016
linear_counter  = $17
linear_status   = $18
linear_old      = $19

noise_length    = $1B
triangle_length = $1C
square0_length  = $1D
square1_length  = $1E

nsf             = $20           ; word
maxsong         = $22
holdcount       = $23
holdset         = $24

screenchange    = $25
bram_ok         = $26
chan1_note      = $28   ; word
chan2_note      = $2A   ; word
chan3_note      = $2C   ; word
chan1_enable    = $2E   ; word
chan2_enable    = $30   ; word
chan3_enable    = $32   ; word

addr_long_lo    = $34
addr_long_hi    = $35
addr_long_bank  = $36
addr2_long_lo   = $37
addr2_long_hi   = $38
addr2_long_bank = $39

sine_count1     = $3A
sine_count2     = $3B
sine_thingy     = $3C

offset1         = $80
offset2         = $81
offset3         = $82
offset4         = $83
time1           = $84
time2           = $85
time3           = $86
time4           = $87

scrolltext_offset       = $88   ; word
bg3_scroll      = $8A
write_delay     = $8B
scroll_vram     = $8C   ; word
playspeed       = $8E
playspeed_count = $8F
megacount       = $90   ; 4 bytes


plasma_buffer   = $0800


;hdma_pal        = $1000
hdma_table      = $1000

sprites         = $1200

nsf_list_compare = $14F2         ; word
nsf_list_offset = $14F4         ; word
count2          = $14F6
count_lo        = $14F8
count_hi        = $14F9
viewtype        = $14FA
status          = $14FB
countro         = $14FC         ; word
curr_screen     = $14FE         ; word
scrollcount_lo  = $1500
scrollcount_hi  = $1501

regbits   = $1500          ; 1 byte for every bit of 16 NES register bytes


bram_song       = $700000
bram_screen     = $700001       ; word


nsf_lowlimit    = 452
nsf_highlimit   = 462

nsf_limit       = 471           ; number of NSFs in ROM


;----------------------------------------
;       button definitions
;----------------------------------------
a_button        = %0000000010000000
x_button        = %0000000001000000
l_button        = %0000000000100000
r_button        = %0000000000010000
b_button        = %1000000000000000
y_button        = %0100000000000000
select_button   = %0010000000000000
start_button    = %0001000000000000
up_button       = %0000100000000000
down_button     = %0000010000000000
left_button     = %0000001000000000
right_button    = %0000000100000000

a_button8       = %10000000
x_button8       = %01000000
l_button8       = %00100000
r_button8       = %00010000
b_button8       = %10000000
y_button8       = %01000000
select_button8  = %00100000
start_button8   = %00010000
up_button8      = %00001000
down_button8    = %00000100
left_button8    = %00000010
right_button8   = %00000001


;======================================================
;       Code
;======================================================
.org    $C00000


.hirom off

phont:  .incbin "snes2.chr"



.pad
.hirom on

start:
        sei
        cld
        
        clc             ; native mode
        xce

;        jml $C08008
        
        phk
        plb

        lda #0
        sta $420D       ; fast mode
        lda $4210
        stz $4200       ; disable NMI



.mem 16
.index 16
        rep #$30

;        rep #$20
;        lda.w #$0000
;        tcd


;----------------
        php
        rep #$30
.mem 16
        ldx.w #0
        txa
-
        sta $0000,x
        inx
        inx
        cpx.w #$2000
        bne -

        ldx.w #$8000
-
        sta $7E0000,x
        inx
        inx
        bne -

        tax
-
        sta $7F0000,x
        inx
        inx
        bne -
        plp
.mem 8

;----------------

.mem 8
        rep #$10        ; 16bit index
        sep #$20        ; 8bit mem

        jsr InitializeSNES
;        jsr clear_bram         ; 32k BRAM
;        jsr clear_ram
        jsr clear_vram

.mem 16
        rep #$20
        lda.w #$1000
        tcd
.mem 8
        rep #$10        ; 16bit index
        sep #$20        ; 8bit mem

        jsr InitSoundCPU
        phk
        plb

        lda bram_ok

        ldx.w #9*001
        stx.w curr_screen
;        jsr draw_screen

        jsr dma_chrset
        lda #$F0
        sta $2109       ; BG3 map location
        lda #$0D
        sta $210C       ; BG3 tile location




        ldx.w #5*001
        rep #$20
        lda.w #5*001
        sta nsf
        sep #$20
;        jsr unpack_nsf



.mem 8        
        sep #$20

        stz test_lo
        stz test_hi

;        jsr setup_spc

;.mem 16
;        rep #$20
;        lda.w #$0000
;        tcd
.mem 8
        rep #$10        ; 16bit index
        sep #$20        ; 8bit mem



.index 16
        rep #$10

            

;        jsr InitSoundCPU


;        lda song        ; get starting song
;        dec a
;        jsl $7F5003     ; NSF init
;        phk        
;        plb


;        jsr dma_chrset


;-------
        lda #%00000011
        sta $2101       ; 8x8 sprites at $4000 (VRAM)
        lda #$80
        sta $1201
        lda #$90
        sta $1205
        lda #$A0
        sta $1209
        lda #$B0
        sta $120D

        lda #$20
        sta $7F4116


;        jmp 


;;---- shheeit

        rep #$20
.mem 16
        lda #$0000 
        ldx #$0400
-
        sta plasma_buffer,x
        dex
        dex
        bne -

        sep #$20
.mem 8

;        jmp d4s_mode

        

        jsr intro

        ldx.w #$0100
-
        lda #0
        sta sprites,x
        dex
        bne -

        lda #$80
        sta $2100

        ldx #$4000
        ldy #$0100
        stx $2116
-
        stz $2118
        stz $2119

        dey
        bne -

        ldx #$F320
        stx $2116
        ldy #$20
-
        stz $2118
        stz $2119
        dey
        bne -
        sty $2116

        lda #$0F
        sta $2100

        stz screenchange
        stz $2111
        stz $2111
        stz $2112
        stz $2112



        ldx #$0400
        lda #0
-
        sta plasma_buffer,x
        dex
        bne -

        jsr send_plasma_buffer          ; clear buffer



        jsr write_main_pal

;-------
        ldx.w #$800             ; set attributes for info display
        lda #$04
-
        sta regbits-1,x
        dex
        dex
        bne -

;-------


        lda #%10000001  ; enable controller and NMI
        sta $4200
-
        lda #%00001001  ; mode 1 with highest priority for BG3
        sta $2105
        
        lda #%00010111  ; BG 1 (sprites disabled)
        sta $212C

;        lda #0
;        sta $2107       ; BG1 vram location
;        lda #$01
;        sta $210B       ; BG1 vram location
;
;        lda #$40        
;        sta $2109       ; BG3 vram location
;        lda #$06        
;        sta $210C       ; BG3 vram location

        lda #$40
        sta $2107       ; BG1 map location
        lda #$16
        sta $210B       ; BG2/BG1 tile location

        lda #$00
        sta $2108       ; BG2 map location

        lda #$F0
        sta $2109       ; BG3 map location
        lda #$0D
        sta $210C       ; BG3 tile location


        lda #$0E                ; selector sprite
        sta sprites+$41


        lda song
        cmp song   ; evil!
        bne -

        lda bram_ok
        beq +
        lda song
        sta song
+
;        lda song        ; get starting song
;        jsl $7F5003     ; NSF init
;        phk        
;        plb


;        lda #$FF
;        sta $2106       ; pixelize

        lda #%00001111  ; screen on
        sta $2100

        stz test_lo            ; temporary***************************=-=-

        ldx.w #$82AB
        stx $0226


;        jsr pixelfade

        jsr selection

        lda #1
        sta status

        lda #$20
        sta $7F4116

        lda #$2
        sta playspeed
        sta playspeed_count


        ldx #0
runit:        
;        jsl $7F5000
;        phk
;        plb
;        inc temp_lo
;        ldx temp_lo
;        cpx #$80
;        bne runit

;============================================
;                       Main loop
;                               waits for 60hz interrupt
;                               runs NES code
;                               runs graphics display code
;                               emulates 60hz length counter
;                               updates APU with NES register contents
;                               checks joypads and processes such
;                               resets $4016 (used by $4015 evaluator)
;                             go to beginning of main loop
;--------------------------------------------

wait:
        wai


        lda #$0F
        sta $2100

        jsr write_oam


                        ; delay
        ldx.w #$06B0
-
        dex
        bne -        



        lda viewtype
        cmp #6
        bne +

;        jsr set_bg_nsf

+

        lda playspeed_count
        cmp #1
        beq +
        dec a
        cmp #1
        beq reset_count
        sta playspeed_count
        jmp slow_it
reset_count:
        lda playspeed

+
        sta playspeed_count
        

       
        lda #%00000001
        sta $4200
        jsl $7F5000     ; NSF play
        phk
        plb
        lda #%10000001
        sta $4200

        lda viewtype
        cmp #6
        bne +

;        jsr set_bg_black2

+


        jsr detect_changes
        jsr emulate_length_counter
        jsr backup_regs
        jsr update_dsp

slow_it:
        jsr check_buttons
        jsr proc_buttons

;        jsr read_oam

        jsr display_options


;        lda #0
;        sta $7F4116
        lda $7F4116
        and #$20
        sta $7F4116


        jmp wait


;============================================
;                       Program Intro
;--------------------------------------------
intro:
        lda #1
        sta screenchange
        stz status

;------------------------------------   ; sound stuff


;        jsr clear_nes_sound
;        jsr update_dsp
        
        jsr clear_nes_space
        jsr clear_wram
;        jsr set_work_rasters


        rep #$20
.mem 16
        lda intro_nsf+8
        sta load_addy
        tax

        phx
        ldx.w #0
-
        lda intro_nsf+$80,x
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
        phx
        ldx temp_lo
        inx
        inx
        cpx.w #$8000    ;(intro_nsf_end - intro_nsf)
        bne -

        plx

        sep #$20
.mem 8


        ldx.w #0
-        
        lda nescode,x
        sta $7F5000,x
        inx
        cpx #$0100
        bne -


        lda #1
        sta square0_length
        sta square1_length
        sta triangle_length
        sta noise_length

        lda intro_nsf+$A
        sta init_lo
        lda intro_nsf+$B
        sta init_hi
        lda intro_nsf+$C
        sta play_lo
        lda intro_nsf+$D
        sta play_hi

        lda #%00000001
        sta $4200



        lda #0

        jsl $7F5003
        phk
        plb
        lda #%10000001
        sta $4200




;------------------------------------

        

;        jsr weird_init

        ldx #0
        jsr draw_screen

        stz screenchange
        stz $2121
        stz $2122
        stz $2122


        jsr init_plasma

;        stz $2121               ; write palette

        lda #$20
        sta $2121

        ldx temp_lo
        lda #<plasmacol  
        sta temp_long           ; addr_lo
        lda #>plasmacol  
        sta temp_long+1         ; addr_hi
        lda #^plasmacol  
        sta temp_long+2         ; bank byte
        stz temp_lo
-        
        lda [temp_long]           ; indirect long
        sta $2122
        inc temp_long
        inc temp_lo
        lda temp_lo
;        cmp #32
        bne -

        jsr write_main_pal


        jsr dma_chrset

        ldx #0
-
        lda hdma_copy
        sta hdma_table,x
        inx
        cpx #7
        bne -


        lda #$00
        sta $2107       ; BG1 map location
        lda #%01100001  ;#$16
        sta $210B       ; BG2/BG1 tile location

        lda #$40
        sta $2108       ; BG2 map location

        ldx.w #$F320
        stx scroll_vram
        lda #$FD
        sta $2112
        stz $2112
;        lda #1
;        sta $2124

        lda #0
        sta $2123
        sta $2124

        lda #$40
        sta $2127
        lda #$C0
        sta $2126
        lda #%00010000
        sta $212A

                        ; setup sprite text fader thingies
        lda #$CA
        sta sprites+1
        sta sprites+5
        sta sprites+9
        sta sprites+13
        sta sprites+17
        sta sprites+21

        stz sprites
        lda #8
        sta sprites+4
        lda #16
        sta sprites+8
        lda #$F8
        sta sprites+12
        lda #$F0
        sta sprites+16
        lda #$E8
        sta sprites+20

        lda #%00000000
        sta sprites+3
        sta sprites+7
        sta sprites+11
        lda #%01000000
        sta sprites+15
        sta sprites+19
        sta sprites+23

        lda #$1D
        sta sprites+2
        sta sprites+14
        inc a
        sta sprites+6
        sta sprites+18
        inc a
        sta sprites+10
        sta sprites+22

        jsr write_oam



        lda #$01
        sta $2105       ; Mode 1
        lda #$0F
        sta $2100       ; screen on

        lda #%00010111
        sta $212C


introloop:
        wai


        jsr send_plasma_buffer


        jsr update_plasma



;        jsr weird
        jsr check_buttons

        lda #start_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +
        wai
        rts

+
;        lda #a_button8
;        and joy1+1
;        beq +
;        and joy1old+1
;        bne +
;        jmp weirdpart
;
;+




        lda #%00000001
        sta $4200
        jsl $7F5000     ; NSF play
        phk
        plb
        lda #%10000001
        sta $4200

;        jsr vis_play
;        jsr write_oam




        jsr detect_changes
        jsr emulate_length_counter
        jsr backup_regs
        jsr update_dsp
        
;        lda #0
;        sta $7F4116
        lda $7F4116
        and #$20
        sta $7F4116



        wai

        jsr scroller

        jsr update_plasma2

        jsr check_buttons

        lda #start_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +
        rts
+
;        lda #a_button8
;        and joy1+1
;        beq +
;        and joy1old+1
;        bne +
;        jmp weirdpart
;
;+


        lda #%00000001
        sta $4200
        jsl $7F5000     ; NSF play
        phk
        plb
        lda #%10000001
        sta $4200


        jsr detect_changes
        jsr emulate_length_counter
        jsr backup_regs
        jsr update_dsp
        
;        lda #0
;        sta $7F4116
        lda $7F4116
        and #$20
        sta $7F4116




        jmp introloop


weirdpart:
        jsr weird_init

weirdloop:
        wai
        wai

        jsr weird
        jsr check_buttons

        lda #start_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +
        wai
        rts

+
        lda #a_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +
        jmp weirdpart

+



        lda #%00100001
        sta $4200
        jsl $7F5000     ; NSF play
        phk
        plb
        lda #%10100001
        sta $4200


        jsr detect_changes
        jsr emulate_length_counter
        jsr backup_regs
        jsr update_dsp
        
;        lda #0
;        sta $7F4116
        lda $7F4116
        and #$20
        sta $7F4116

        jmp weirdloop




hdma_copy:
        .db 128
        .dw $0808
        .db 64
        .dw $0C0C
        .db 0


scroller:
        lda bg3_scroll
        sta $2111
        stz $2111

        inc bg3_scroll
        inc bg3_scroll

        dec write_delay
        bne +
        lda #4
        sta write_delay

        lda #$80
        sta $2100
        
        ldx scroll_vram
        stx $2116

        ldx scrolltext_offset
        lda scrolltext,x
        sta $2118
        lda #%00010000
        sta $2119

        lda #$0F
        sta $2100

        inx
        stx scrolltext_offset

        ldx scroll_vram
        inx
;        inx
        stx scroll_vram
        cpx #$F340
        bne +
        ldx #$F320
        stx scroll_vram
+
        rts



plasmacol:
;       .dw %0000000000000000
;       .dw %0000010000100001
;        .dw %0000100001000010
;       .dw %0000110001100011
;       .dw %0001000010000100
;       .dw %0001010010100101
;       .dw %0001100011000110
;        .dw %0001110011100111
;       .dw %0010000100001000
;       .dw %0010010100101001
;       .dw %0010100101001010
;       .dw %0010110101101011
;        .dw %0011110111101111
;       .dw %0100001000010000
;       .dw %0100011000110001
;       .dw %0100101001010010
;        .dw %0100111001110011
;        .dw %0101001010010100
;        .dw %0101011010110101

;        .dw %0000000000000001
;        .dw %0000000000000010
;        .dw %0000000000000011
;        .dw %0010010000000100
;        .dw %0010100000000101
;        .dw %0010110000000110
;        .dw %0011000000000111
;        .dw %0010110000001000
;        .dw %0010100000001001
;        .dw %0010010000001010
;        .dw %0000001000101011
;        .dw %0000001001001100
;        .dw %0000001001101101
;        .dw %0000001010001110
;        .dw %0000001001101111
;        .dw %0000001000110000

        .dw %0000100001100011
        .dw %0000110001100011
        .dw %0001000001100011
        .dw %0001010001100011
        .dw %0001100001100011
        .dw %0001110001100011
        .dw %0010000001100011
        .dw %0010010001100011
        .dw %0010100001100011
        .dw %0010110001100011
        .dw %0011000001100011
        .dw %0011010001100011
        .dw %0011100001100011
        .dw %0011110001100011
        .dw %0100000001100011
        .dw %0100010001100011
        .dw %0100100001100011

.pad $C084F0      ; prevent branching over page boundary

update_plasma:

        ldy #0

        lda offset1
        sec
        sbc #3
        sta offset1
        lda offset2
        clc
        adc #5
        sta offset2
        lda offset3
        sec
        sbc #4
        sta offset3
        lda offset4
        sec
        sbc #8
        sta offset4

        lda offset1
        bne flow
        lda offset2
        bne flow
        lda offset3
        bne flow
        lda offset4
        bne flow

        inc megacount
        inc megacount
        bne +
        inc megacount+1
        inc megacount+1
        bne +
        inc megacount+2
        inc megacount+2
        bne +
        inc megacount+3
        inc megacount+3
+

        lda megacount
        adc #5
        sta offset1
        lda megacount+1
        sta offset2
        lda megacount+2
        sbc #2
        sta offset3
        lda megacount+3
        sta offset4
        

flow:
        lda offset3
        clc
        adc #53
        sta time3
        lda offset4
        clc
        adc #98
        sta time4

        ldx #$20
 ;       sta sine_count1
        lda #$0C
        sta sine_count2

        sty sine_thingy

        sep #$10
.index 8



do_v_row:

        lda offset1
;        sec
        sbc #43
        sta time1
        lda offset1
;        sec
        sbc #66
        sta time2
do_h_row:


;        xba
;        lda #0
;        xba        

        ldy time1
        lda #0
        clc
        adc !psine1,y

;        xba
;        adc #0
;        xba

        ldy time3
;        clc
        adc !psine1,y

;        xba
;        adc #0
;        xba

        ldy time2
;        clc
        adc !psine1,y

;        xba
;        adc #0
;        xba

        ldy time4
;        clc
        adc !psine1,y

;        rep #$20
;.mem 16
;        adc #0
        lsr
        lsr
;        lsr
;        lsr
;        lsr
;        lsr

;        sep #$20
;.mem 8

        rep #$10
.index 16

        ldy sine_thingy

        clc
        adc #$A0

        sta plasma_buffer+$2,y
        iny
        iny

        sty sine_thingy

        sep #$10
.index 8


;        clc
        lda time1
        adc #6
        sta time1

;        sec
        lda time2
        sbc #4          ; 5 without SEC
        sta time2


;        dec sine_count1
        dex
        bne do_h_row

        ldx #$20
;        sta sine_count1

        inc time3
        sec
        lda time4
        sbc #3
        sta time4

        dec sine_count2
        bne do_v_row

        rep #$10
.index 16


        rts


update_plasma2:


        ldx #$20
 ;       sta sine_count1
        lda #$0D
        sta sine_count2

        ldy sine_thingy

        sep #$10
.index 8



do_v_row2:

        lda offset1
;        sec
        sbc #43
        sta time1
        lda offset1
;        sec
        sbc #66
        sta time2
do_h_row2:


        ldy time1
        lda #0
        clc
        adc !psine1,y

        ldy time3
;        clc
        adc !psine1,y


        ldy time2
;        clc
        adc !psine1,y

        ldy time4
;        clc
        adc !psine1,y

        lsr
        lsr

        rep #$10
.index 16

        ldy sine_thingy

        clc
        adc #$A0

        sta plasma_buffer+$2,y
        iny
        iny

        sty sine_thingy

        sep #$10
.index 8


;        clc
        lda time1
        adc #6
        sta time1

;        sec
        lda time2
        sbc #4          ; 5 without SEC
        sta time2


        dex
        bne do_h_row2

        ldx #$20
;        sta sine_count1

        inc time3
        sec
        lda time4
        sbc #3
        sta time4

        dec sine_count2
        bne do_v_row2

        rep #$10
.index 16


        rts



init_plasma:
;        ldx.w #$C00
;        lda #$04
;-
;        sta plasma_buffer-1,x
;        dex
;        dex
;        bne -
        
        rts



weird:
        ldx.w count_lo
        lda sinex,x

        sec
        sbc #4
        sta $210D
        stz $210D

        inc count_lo
        bne +
        inc count_hi
+
        ldx.w count_lo
        cpx #1024
        bne +
        stz count_lo
        stz count_hi

+


        ldx.w scrollcount_lo
        lda sinex,x

        sec
        sbc #4
        sta $210E
        stz $210E

        inc scrollcount_lo
        bne +
        inc scrollcount_hi
+
        ldx.w scrollcount_lo
        cpx #1024
        bne +
        stz scrollcount_lo
        stz scrollcount_hi

+

;---
        lda scrollcount_lo
        clc
        adc #$80
        xba
        lda scrollcount_hi
        adc #0
        xba
        tax
        lda sinex,x

        sta $210F
        stz $210F
        sta $2110
        stz $2110
;---


        rts

weird_init:
        php
        rep     #$10            ; X,Y fixed -> 16 bit mode
        sep     #$20            ; Accumulator ->  8 bit mode

        lda #<spiralset 
        sta $65
        lda #>spiralset  
        sta $66
        lda #^spiralset  
        sta $67
        stx temp_lo
        ldx.w #$A000
        stx $68
        lda #$7E
        pha
        plb
        jsr UNPACK

        sep #$20        

        phk
        plb


        ldx temp_lo

        lda #<spiralmap  
        sta $65
        lda #>spiralmap  
        sta $66
        lda #^spiralmap   
        sta $67
        stx temp_lo
        ldx.w #$E000
        stx $68
        lda #$7E
        pha
        plb
        jsr UNPACK

        sep #$20
        
        phk
        plb

        jsr dma_tiles

        stz $2121               ; write palette
        ldx temp_lo
        lda #<spiralcol  
        sta temp_long           ; addr_lo
        lda #>spiralcol  
        sta temp_long+1         ; addr_hi
        lda #^spiralcol  
        sta temp_long+2         ; bank byte
        stz temp_lo
-        
        lda [temp_long]           ; indirect long
        sta $2122
        inc temp_long
        inc temp_lo
        lda temp_lo
        cmp #32
        bne -

        jsr write_main_pal

        jsr dma_chrset

        plp

        stz count_lo
        stz count_hi

        stz scrollcount_hi
        lda #$40
        sta scrollcount_lo



        lda #$00
        sta $2107       ; BG1 map location
        lda #$11
        sta $210B       ; BG2/BG1 tile location

        lda #$00
        sta $2108       ; BG2 map location

        lda #$40
        sta $2109       ; BG3 map location
        lda #$01
        sta $210C       ; BG3 tile location


        lda #$01
        sta $2105       ; Mode 1
        lda #$0F
        sta $2100       ; screen on

        lda #%00000011
        sta $212C

        rts



        lda #0
        jsl $7F5003
        phk
        plb

        lda #$80
        sta $4200

        lda #$40
        sta count2

eatthis:
        jsr write_oam

        wai

        jsl $7F5000
        phk
        plb

        jsr detect_changes
        jsr emulate_length_counter
        jsr backup_regs
        jsr update_dsp

        lda #$23
        sta $1203

        ldx.w count_lo
        lda $C00000,x
        sta $1200
        inx
        cpx.w #$0100
        bne +
        ldx.w #0
+
        stx count_lo

        ldx.w count2
        lda $C00000,x
        sta $1201
        inx
        cpx.w #$0100
        bne +
        ldx.w #0
+
        stx count2


        
        bra eatthis



hdmazero:
        .db $10
        .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
        .db 0   ; end
        


;============================================
;                       Graphical info display
;                               checks 'viewtype' variable
;                               runs note/volume/register monitors accordingly
;--------------------------------------------

display_options:
        jsr vis_play

        lda viewtype
        bne registers

        jsr notemon             ; default mode
        jsr volmon
        jsr wavemon
        jsr fxmon
        lda #%00010011  ; BG 1
        sta $212C
        rts

registers:
        cmp #1
        bne +

        jsr regmon              
        lda #%00010011  ;       ; register view mode
        sta $212C
        rts

+
        cmp #2
        bne +
        lda #%00010011  ;       
        sta $212C
        rts

+
        cmp #3
        bne +

        lda #%00000010          ; graphic mode
        sta $212C
        rts
+
        cmp #4
        bne +
        jsr notemon
        jsr volmon
        jsr wavemon
        jsr fxmon
        lda #%00010001
        sta $212C
        rts
+
        cmp #5
        bne +

        jsr regmon
        lda #%00010001
        sta $212C
        rts
+
        cmp #6
        bne +

;        lda #$09                ; screen time
;        sta $2100
        jsr notemon
        jsr volmon
        jsr wavemon
        jsr fxmon
        lda #%00010011
        sta $212C
        rts
+
        jsr notemon
        jsr volmon
        jsr wavemon
        jsr fxmon
        jsr piano_view

        lda #%00010001
        sta $212C
        rts



amount  = $08

;============================================
;                       Piano View
;                               shows keyboard
;--------------------------------------------
piano_view:

        ldx #0
        ldy #5
        lda #$84
        sta regbits+$278,x
        sta regbits+$378,x
-
        inc a
        cmp #$8B
        beq +
        inx
        inx
        sta regbits+$278,x
        sta regbits+$378,x
        bra -
+
        lda #$83
        dey
        bne -


        ldx #0
        lda #$95
-
        sta regbits+$2B8,x
        sta regbits+$3B8,x
        inx
        inx
        cpx #$40
        bne -

        lda #$7F
        sta $1202
        sta $1206
        sta $120A

        ldx chan1_enable
        bne +
        stz $1202
+
        ldx chan1_note

        lda piano_table,x
        sta $1200
        lda piano_table+1,x
        sta $1201

        ldx chan2_enable
        bne +
        stz $1206
+

        ldx chan2_note
        lda piano_table,x
        sta $1204
        lda piano_table+1,x
        sta $1205

        ldx chan3_enable
        bne +
        stz $120A
+

        ldx chan3_note
        lda piano_table,x
        sta $1208
        lda piano_table+1,x
        clc
        adc #32
        sta $1209


        rts


piano_table:
        .db $14,$7F     ; A-1
        .db $16,$77     ; A#1
        .db $18,$7F     ; B-1
        .db $1C,$7F     ; C-2
        .db $1E,$77     ; C#2
        .db $20,$7F     ; D-2
        .db $22,$77     ; D#2
        .db $24,$7F     ; E-2
        .db $28,$7F     ; F-2
        .db $2A,$77     ; F#2
        .db $2C,$7F     ; G-2
        .db $2E,$77     ; G#2
        .db $30,$7F     ; A-2
        .DB $32,$77     ; A#2
        .DB $34,$7F     ; B-2
        .DB $38,$7F     ; C-3
        .DB $3A,$77     ; C#3
        .DB $3C,$7F     ; D-3
        .DB $3E,$77     ; D#3
        .DB $40,$7F     ; E-3
        .DB $44,$7F     ; F-3
        .DB $46,$77     ; F#3
        .DB $48,$7F     ; G-3
        .DB $4A,$77     ; G#3
        .DB $4C,$7F     ; A-3
        .DB $4E,$77     ; A#3
        .DB $50,$7F     ; B-3
        .DB $54,$7F     ; C-4
        .DB $56,$77     ; C#4
        .DB $58,$7F     ; D-4
        .DB $5A,$77     ; D#4
        .DB $5C,$7F     ; E-4
        .DB $60,$7F     ; F-4
        .DB $62,$77     ; F#4
        .DB $64,$7F     ; G-4
        .DB $66,$77     ; G#4
        .DB $68,$7F     ; A-4
        .DB $6A,$77     ; A#4
        .DB $6C,$7F     ; B-4
        .DB $70,$7F     ; C-5
        .DB $72,$77     ; C#5
        .DB $74,$7F     ; D-5
        .DB $76,$77     ; D#5
        .DB $78,$7F     ; E-5
        .DB $7C,$7F     ; F-5
        .DB $7E,$77     ; F#5
        .DB $80,$7F     ; G-5
        .DB $82,$77     ; G#5
        .DB $84,$7F     ; A-5
        .DB $86,$77     ; A#5
        .DB $88,$7F     ; B-5
        .DB $8C,$7F     ; C-6
        .DB $8E,$77     ; C#6
        .DB $90,$7F     ; D-6
        .DB $92,$77     ; D#6
        .DB $94,$7F     ; E-6
        .DB $98,$7F     ; F-6
        .DB $9A,$77     ; F#6
        .DB $9C,$7F     ; G-6
        .DB $9E,$77     ; G#6
        .DB $A0,$7F     ; A-6
        .DB $A2,$77     ; A#6
        .DB $A4,$7F     ; B-6
        .DB $A8,$7F     ; C-7
        .DB $AA,$77     ; C#7
        .DB $AC,$7F     ; D-7
        .DB $AE,$77     ; D#7
        .DB $B0,$7F     ; E-7
        .DB $B4,$7F     ; F-7
;        .DB $B6,$77     ; F#7
        .DB $B8,$7F     ; G-7
        .DB $BA,$77     ; G#7
        .DB $BC,$7F     ; A-7
        .DB $BE,$77     ; A#7
        .DB $C0,$7F     ; B-7
        .DB $C4,$7F     ; C-8
        .DB $C6,$77     ; C#8
        .DB $C8,$7F     ; D-8
        .DB $CA,$77     ; D#8
        .DB $CC,$7F     ; E-8
        .DB $D0,$7F     ; F-8
        .DB $D2,$77     ; F#8
        .DB $D4,$7F     ; G-8
        .DB $D6,$77     ; G#8
        .DB $D8,$7F     ; A-8
        .DB $DA,$77     ; A#8
        .DB $DC,$7F     ; B-8
        .DB $E0,$7F     ; C-8
        .DB $E2,$77     ; C#8
        .DB $E4,$7F     ; D-8
        .DB $E6,$77     ; D#8
        .DB $E8,$7F     ; E-8
        .DB $EC,$7F     ; F-8

        .db $80,$80
        .db $80,$80
        .db $80,$80
        .db $80,$80





        


;============================================
;                       Effect Monitor
;                               displays hardware effects status
;--------------------------------------------
fxmon:
        stz temp_lo

        lda $7F4103
        and #%00000111
        bne +
        lda $7F4102
        cmp #8
        bcs +
        bra sweepoff
+
        lda $7F4100
        and #%00010000
        bne decayoff

        lda temp_lo
        ora #%00000010
        sta temp_lo
        bra +

decayoff:
        lda temp_lo
        and #%00000001
        sta temp_lo
+
        lda $7F4101
        and #%10000000
        beq sweepoff
        lda $7F4101
        and #%00000111
        beq sweepoff

        lda temp_lo
        ora #%00000001
        sta temp_lo
        bra +

sweepoff:
        lda temp_lo
        and #%00000010
        sta temp_lo
+
        xba
        lda #0
        xba

        lda temp_lo
        asl
        asl
        asl
        asl
        tax

        ldy #0
-
        lda fxtable,x
        sta regbits+$BA,y
        inx
        iny
        cpy #12
        bne -


        stz temp_lo

        lda $7F4107
        and #%00000111
        bne +
        lda $7F4106
        cmp #8
        bcs +
        bra sweepoff2
+
        lda $7F4104
        and #%00010000
        bne decayoff2

        lda temp_lo
        ora #%00000010
        sta temp_lo
        bra +

decayoff2:
        lda temp_lo
        and #%00000001
        sta temp_lo
+
        lda $7F4105
        and #%10000000
        beq sweepoff2
        lda $7F4105
        and #%00000111
        beq sweepoff2

        lda temp_lo
        ora #%00000001
        sta temp_lo
        bra +

sweepoff2:
        lda temp_lo
        and #%00000010
        sta temp_lo
+
        xba
        lda #0
        xba

        lda temp_lo
        asl
        asl
        asl
        asl
        tax

        ldy #0
-
        lda fxtable,x
        sta regbits+$FA,y
        inx
        iny
        cpy #12
        bne -


        lda $7F4108
        and #%01111111
        beq notime

        lda $7F4108
        and #%10000000
        beq +
notime:
        lda #0
        sta regbits+$0140
        sta regbits+$0142
        sta regbits+$0144
        bra timeroff

+
        lda #$9A
        sta regbits+$0140
        inc a            
        sta regbits+$0142
        inc a
        sta regbits+$0144
timeroff:

        stz temp_lo
        lda $7F410C
        and #%00010000
        bne decayoff3

        lda temp_lo
        ora #%00000010
        sta temp_lo
        bra +

decayoff3:
        lda temp_lo
        and #%00000001
        sta temp_lo
+

        xba
        lda #0
        xba

        lda temp_lo
        asl
        asl
        asl
        asl
        tax

        ldy #0
-
        lda fxtable,x
        sta regbits+$017A,y
        inx
        iny
        cpy #12
        bne -



        rts


fxtable:
        .dw $0400,$0400,$0400,$0400,$0400,$0400,$0400,$0400 ; none
        .dw $0400,$0400,$0400,$0496,$0497,$0498,$0400,$0400 ; sweep
        .dw $0400,$0400,$0400,$048B,$048C,$048D,$0400,$0400 ; decay
        .dw $0496,$0497,$048E,$048B,$048C,$048D,$0400,$0400 ; sweep+decay


;============================================
;                       Waveform monitor
;                               displays waveform for 4 channels
;--------------------------------------------
wavemon:
        php

        rep #$30
.mem 16
        lda $7F4102
        and #%1111111111100000
        bne +
        bra sqw0
+
        lda $7F4115
        and #%0000000000000001
        beq sqw0

        lda $7F4100
        and #%0000000000010000
        beq +

        lda $7F4100
        and #%0000000000001111
        bne +
sqw0:
        lda #$0400
        sta regbits+$C6
        sta regbits+$C8
        bra sqwx0

+
        lda $7F4100
        and #%0000000011000000
        lsr
        lsr
        lsr
        lsr

        tax

        lda waveform_table,x
        sta regbits+$C6
        lda waveform_table+2,x
        sta regbits+$C8

sqwx0:

        lda $7F4106
        and #%1111111111100000
        bne +
        bra sqw1
+
        lda $7F4115
        and #%0000000000000010
        beq sqw1

        lda $7F4104
        and #%0000000000010000
        beq +

        lda $7F4104
        and #%0000000000001111
        bne +
sqw1:
        lda #$0400
        sta regbits+$106
        sta regbits+$108
        bra sqwx1

+
        lda $7F4104
        and #%0000000011000000
        lsr
        lsr
        lsr
        lsr

        tax

        lda waveform_table,x
        sta regbits+$106
        lda waveform_table+2,x
        sta regbits+$108

sqwx1:

        lda $7F4008
        and #%0000000001111111
        bne +
        bra trxx        
+
        lda $7F4115
        and #%0000000000000100
        bne +

        lda #$0400
        sta regbits+$146
        sta regbits+$148
        bra trx1
+
trxx:
        lda #$040B
        sta regbits+$146
        lda #$040C
        sta regbits+$148

trx1:
        lda $7F400C
        and #%0000000000001111
        bne +

        lda #$0400
        sta regbits+$186
        sta regbits+$188
        bra noisx
+

        lda $7F400E
        and #%0000000010000000
        beq +

        lda #$0415
        sta regbits+$186
        lda #$0416
        sta regbits+$188
        bra noisx

+
        lda regbits+$186
        cmp #$040D
        beq +

        lda #$040D
        sta regbits+$186
        lda #$040E
        sta regbits+$188

noisx:
        plp
        rts
+
        lda #$040E
        sta regbits+$186
        lda #$040D
        sta regbits+$188
        plp
        rts


waveform_table:
        .dw $0405,$0406     ; 17.5% pulse
        .dw $0407,$0408     ; 25% pulse
        .dw $0409,$040A     ; 50% pulse
        .dw $0413,$0414     ; 75% pulse
        .dw $040B,$040C     ; triangle
        .dw $040D,$040E     ; noise

;============================================
;                       Volume monitor
;                               displays volume bars for 4 channels
;--------------------------------------------
volmon:
        php

        rep #$30
.mem 16
        lda $7F4002
        and.w #%0000011111111111
        bne +
-
        ldx #0
        bra off1
+
        lda $7F4115
        and.w #%0000000000000001
        beq -

        lda $7F4000
        and.w #%0000000000001111

        asl
        asl
        asl
        asl
        asl
        tax
off1:
        ldy.w #$00D4
-
        lda volume_block_table,x
        sta regbits,y
        iny
        iny
        inx
        inx
        cpy #$D4+32
        bne -

        lda $7F4006
        and.w #%0000011111111111
        bne +
-
        ldx #0
        bra off2
+
        lda $7F4115
        and.w #%0000000000000010
        beq -

        lda $7F4004
        and.w #%0000000000001111

        asl
        asl
        asl
        asl
        asl
        tax
off2:
        ldy.w #$0114
-
        lda volume_block_table,x
        sta regbits,y
        iny
        iny
        inx
        inx
        cpy #$0114+32
        bne -

        lda $7F400A
        and.w #%0000011111111111
        bne +
        ldx #0
        bra gotzero
+
        lda $7F4008
        and.w #%0000000001111111
        bne +
-
        ldx.w #0
        bra gotzero
+
        lda $7F4115
        and.w #%0000000000000100
        beq -

        ldx.w #$0F*32
gotzero:
        ldy.w #$0154
-
        lda volume_block_table,x
        sta regbits,y
        iny
        iny
        inx
        inx
        cpy #$0154+32
        bne -

        lda $7F4115
        and.w #%0000000000001000
        bne +
        ldx.w #0
        bra noisebaroff

+
        lda $7F400C
        and.w #%0000000000001111

        asl
        asl
        asl
        asl
        asl
        tax

noisebaroff:

        ldy.w #$0194
-
        lda volume_block_table,x
        sta regbits,y
        iny
        iny
        inx
        inx
        cpy #$0194+32
        bne -

        plp
        rts

;volume_block_table:
;vol0: .dw $0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol1: .dw $0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol2: .dw $0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol3: .dw $0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol4: .dw $0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol5: .dw $0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol6: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol7: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol8: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;vol9: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0480,$0480,$0480,$0480,$0480,$0480,$0480
;volA: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0480,$0480,$0480,$0480,$0480,$0480
;volB: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0480,$0480,$0480,$0480,$0480
;volC: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0480,$0480,$0480,$0480
;volD: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0483,$0480,$0480,$0480
;volE: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0483,$0483,$0480,$0480
;volF: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0483,$0483,$0483,$0480


;============================================
;                       Note Monitor
;                               uses greater-than and less-than checks
;                               to attempt to determine what musical note
;                               is being played
;--------------------------------------------
notemon:
        php
        rep #$30
.mem 16
        lda $7F4100
        and.w #%0000000000010000
        beq +
        lda $7F4100
        and.w #$000F
        bne +
        lda #0
        bra og
+
        lda $7F4102
og
        sta chan1_enable
        jsr findval
        stx chan1_note
        ldy.w #$00CC 
        jsr calculate

        lda $7F4104
        and.w #%0000000000010000
        beq +
        lda $7F4104
        and.w #$000F
        bne +
        lda #0
        bra og1
+
        lda $7F4106
og1
        sta chan2_enable
        jsr findval
        stx chan2_note
        ldy.w #$010C
        jsr calculate

        lda $7F4108
        and.w #$007F
        bne +
        lda #0
        bra og2
+
        lda $7F410A
og2
        sta chan3_enable
        jsr findval

;        cpx #0
;        beq +
;        txa
;        sec
;        sbc #24         ; lower one octave
;        tax
;+

        stx chan3_note
        ldy.w #$014C
        jsr calculate
        
        plp
return: rts

findval:
        and.w #%0000011111111111

        ldx.w #90*2             ; start check at C-3

        cmp note_table,x
        beq return
        bcc higher
lower:
        dex
        dex
        cpx #$FFFE
        beq hit_bottom
        cmp note_table,x
        beq return
        bcs lower
hit_bottom:
        inx
        inx
        rts

higher:
        inx
        inx
        cmp note_table,x
        beq return
        bcc higher

        dex
        dex
        rts

calculate:
        txa
        asl
        asl
        tax

        lda note_names,x
        sta regbits,y           ; vram buffer
        inx
        inx
        iny
        iny
        lda note_names,x
        sta regbits,y
        inx
        inx
        iny
        iny
        lda note_names,x
        sta regbits,y
        inx
        inx
        iny
        iny
        lda note_names,x
        sta regbits,y

        rts
.mem 8

;============================================
stopit:
        stz $2121
        lda #$FF
        sta $2122
        sta $2122
        jmp stopit

;============================================
testy:
        .db $30, $01, $02, $03, $04, $05, $06, $07, $08
        .db $04, $51, $02, $03, $04, $05, $06, $07, $08
        .db $00, $01, $12, $03, $04, $05, $06, $07, $08
        .db $00, $01, $02, $03, $04, $05, $06, $07, $08
        .db $00, $01, $02, $33, $04, $05, $06, $07, $08
        .db $00, $01, $02, $03, $64, $05, $06, $07, $08
        .db $00, $01, $02, $03, $04, $35, $06, $07, $08
        .db $00, $01, $02, $03, $04, $05, $16, $07, $08
        .db $00, $01, $02, $03, $04, $05, $06, $37, $08
        .db $20, $00, $22, $00, $24, $00, $26, $00, $68
        .db $00, $00, $02, $00, $04, $00, $06, $00, $08
        .db $20, $00, $22, $00, $34, $00, $36, $00, $38


;============================================
selection:

        lda #$80
        sta $2100
        stz $212C

        jsr set_bg_black

        ldx.w #$F020
        stx $2116
        ldx.w nsf_list_offset
        ldy.w #$0300
-
        lda nsf_list,x
        sta $2118
        lda #%00010000
        sta $2119
        inx
        dey
        bne -

        lda #0
        ldx.w #0
-
        sta $1203,x
        inx
        inx
        inx
        inx
        cpx #$0004
        bne -

        lda #$08
        sta sprites+$40
        lda #$7E ;#$42
        sta sprites+$42
        lda #$02
        sta sprites+$43

        stz sprites+$02
        stz sprites+$06
        stz sprites+$0A
        stz sprites+$0E

        jsr write_oam

        lda #$0F
        sta $2100       ; screen on
        lda #%00010100
        sta $212C


select_loop:
        wai
        jsr write_oam

        lda #1
        sta $4200
        jsl $7F5000     ; NSF play
        phk
        plb
        lda #%10000001
        sta $4200


        jsr detect_changes
        jsr emulate_length_counter
        jsr backup_regs
        jsr update_dsp

        jsr check_buttons
menu_buttons:

        ldx.w curr_screen
        beq gooo

        lda #up_button8
        and joy1+1
        beq +
        and joy1old+1
        beq up_not_held
     
        lda holdset
        cmp #25
        beq up_held
        inc holdset
gooo:
        bra +

up_held:
        inc holdcount
        lda holdcount
        cmp #2
        bne +
        lda #0
        sta holdcount
        bra up_fastmove

up_not_held:
        lda #0
        sta holdset
up_fastmove:

        sec
        lda $1241
        sbc #8
        cmp #$FE  
        bne samepagey

        lda #$80
        sta $2100
        stz $212C

        ldx.w #$F020
        stx $2116

        rep #$20
.mem 16
        lda nsf_list_offset
        sec
        sbc #$0300
        sta nsf_list_offset
        tax

        ldy.w #$0300

        sep #$20
.mem 8

-
        lda nsf_list,x
        sta $2118
        lda #%00010000
        sta $2119
        inx
        dey
        bne -

        lda #$0F
        sta $2100
        lda #%00010100
        sta $212C

        lda #$BE

samepagey:
        sta $1241

        rep #$30
.mem 16
        lda curr_screen
        sec
        sbc #9
        sta curr_screen

        lda nsf
        sec
        sbc #5
        sta nsf

        sep #$20
.mem 8

+

        ldx curr_screen
        cpx #nsf_limit*9
        beq gooo2

        lda #down_button8
        and joy1+1
        beq +
        and joy1old+1
        beq down_not_held

        lda holdset
        cmp #25
        beq down_held
        inc holdset
gooo2:
        bra +

down_held:
        inc holdcount
        lda holdcount
        cmp #2
        bne +
        lda #0
        sta holdcount
        bra down_fastmove

down_not_held:
        lda #0
        sta holdset
down_fastmove:
        clc
        lda $1241
        adc #8
        cmp #$C0+6
        bne samepage

        lda #$80
        sta $2100
        stz $212C

        ldx.w #$F020
        stx $2116

        rep #$20
.mem 16
        lda nsf_list_offset
        clc
        adc #$0300
        sta nsf_list_offset
        tax

        ldy.w #$0300

        sep #$20
.mem 8

-
        lda nsf_list,x
        sta $2118
        lda #%00010000
        sta $2119
        inx
        dey
        bne -

        lda #$0F
        sta $2100
        lda #%00010100
        sta $212C

        lda #$06

samepage:
        sta $1241

        rep #$30
.mem 16
        lda curr_screen
        clc
        adc #9
        sta curr_screen

        lda nsf
        clc
        adc #5
        sta nsf

        sep #$20
.mem 8

+
        lda #start_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +

        stz $1242               ; selector sprite

        lda #$2
        sta playspeed
        sta playspeed_count


        lda #%00000100
        sta $212C

        lda #0
        sta $7F4115
        jsr update_dsp


        ldx nsf
        stz status
        jsr unpack_nsf
        lda #1
        sta status


        lda #1
        sta $4200

        lda song
        jsl $7F5003
        phk
        plb

        lda #%00010011
        sta $212C

        lda #%10000001
        sta $4200


        rts

+
        lda #select_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +

        stz $1242               ; selector sprite

        lda #%00010011
        sta $212C

        rts

+

                                ; check if going past last page
        ldx nsf_list_offset
        cpx #$3680
        bcs +

        lda #right_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +

        ldx nsf_list_offset
        cpx #$3500
        bcc nog
        lda $1241
        cmp #$48+6+(7*8)
        bcs +

nog   

        lda #$80
        sta $2100
        stz $212C

        ldx.w #$F020
        stx $2116

        rep #$20
.mem 16
        lda nsf_list_offset
        clc
        adc #$0300
        sta nsf_list_offset
        tax

        ldy.w #$0300

        sep #$20
.mem 8

-
        lda nsf_list,x
        sta $2118
        lda #%00010000
        sta $2119
        inx
        dey
        bne -

        lda #$0F
        sta $2100
        lda #%00010100
        sta $212C

;        lda #$BE
;
;        sta $1241

        rep #$30
.mem 16
        lda curr_screen
        clc
        adc #9*24
        sta curr_screen

        lda nsf
        clc
        adc #5*24
        sta nsf

        sep #$20
.mem 8

+

                                ; check if going before first page
        ldx.w nsf_list_offset
        cpx.w #$0300
        bcc +

        lda #left_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +
        

        lda #$80
        sta $2100
        stz $212C

        ldx.w #$F020
        stx $2116

        rep #$20
.mem 16
        lda nsf_list_offset
        sec
        sbc #$0300
        sta nsf_list_offset
        tax

        ldy.w #$0300

        sep #$20
.mem 8

-
        lda nsf_list,x
        sta $2118
        lda #%00010000
        sta $2119
        inx
        dey
        bne -

        lda #$0F
        sta $2100
        lda #%00010100
        sta $212C

        rep #$30
.mem 16
        lda curr_screen
        sec
        sbc #9*24
        sta curr_screen

        lda nsf
        sec
        sbc #5*24
        sta nsf

        sep #$20
.mem 8

+

        lda $7F4116
        and #$20
        sta $7F4116        

        jmp select_loop

;============================================
write_main_pal:
        ldx #0
        lda #$80
        sta $2121
-
        lda vispal,x
        sta $2122
        inx
        cpx #128
        bne -

        ldx.w #0
        lda #$10
        sta $2121
-
        lda col85,x
        sta $2122
        inx
        cpx #$20
        bne -
        rts

;============================================
read_oam:
        stz $2102
        stz $2103
        ldx.w #0
-
        lda $2138
        sta $700000,x
        inx
        cpx #512+32
        bne -

        rts


;============================================
;                       Updates Sprite RAM (Object Attribute Memory)
write_oam:
        stz $2102
        stz $2103
        stz $4310
        lda #$04
        sta $4311
        ldx.w #$1200
        stx $4312
        stz $4314
        ldx #272*2
        stx $4315
        lda #%00000010
        sta $420B
        rts

;============================================
;                       Visual Player
;                               displays 'note dots', with the X position
;                               determined by the pitch of the sound,
;                               color determined by the waveform used, and
;                               size determined by volume.
;--------------------------------------------
vis_play:
        php
        sep #$20

        lda #$80
        sta $1201
        lda #$90
        sta $1205
        lda #$A0
        sta $1209
        lda #$B0
        sta $120D

.mem 8
.index 16
        ldx #0
        ldy #0

vp_tileloop:
;        phx
;        tyx
        lda $7F4115      ; check if channel is disabled in $4015
;        plx

        cpy #0
        beq next0
        cpy #1
        beq next1
        cpy #2
        beq next2
        cpy #3
        beq next3
next0:
        and #%00000001
        bne @checknext
        beq not_tri
next1:
        and #%00000010
        bne @checknext
        beq not_tri
next2:
        and #%00000100
        bne @checknext
        beq not_tri
next3:
        and #%00001000
        bne @checknext
        beq not_tri
        

@checknext:
        lda $7F4102,x    ; check if frequency is 0
        bne @ok
        lda $7F4103,x
        and #%00000111
        bne @ok
        lda #0          ; turn tile off it it's 0 (needed for Capcom tunes)
        bne not_tri
@ok:
        lda $7F4100,x    ; check sound volume, and set tile accordingly
        and #%00001111
        cpy #2          ; check if it's doing tri wave
        bne @isnt_tri
        lda $7F4100,x
        and #%01111111
        beq not_tri
;        bra @gohere
        lda #$04
        bra not_tri
@isnt_tri:
        cmp #0
        beq not_tri
@gohere:

        lsr
        lsr
        clc
        adc #$01
        cpy #8
        bne not_tri
        lda #$14
not_tri:
        sta $1202,x

        iny
        inx             ; inc index for saves to sprite ram
        inx             ;
        inx             ;
        inx             ;
        cpx #16         ; if 4 channels are done, leave the loop

        beq +
        jmp vp_tileloop
+

dot_coords:
	ldy #0
	ldx #0
dots:
        lda $7F4103,x
        and #%00000111
        xba
        lda $7F4102,x

        stx test_lo
        tax
        lda freq_table,x
        



next:
        ldx test_lo
;        clc
;        adc #1
        sta $1200,x             ; store to sprite ram
        inx
        inx
        inx
        inx
        cpx #12
	bne dots

        lda $7F4102,x            ; do noise channel
        and #%00001111
        asl
        asl
        asl

        clc
        adc #$40
        eor #$FF
        sta $1200,x


        ldx #0
note_colors:                    ; check duty-cycles
        lda $7F4100,x
        and #%11000000
        lsr
        lsr
        lsr
        lsr
        lsr
        ora #%00110000
        sta $1203,x
        inx
        inx
        inx
        inx
        cpx #16
        bne note_colors

        plp
        rts


;=============================================
detect_changes:
        lda $7F4000
        and #%00100000
        bne decay_disabled0

        lda $7F4003
        beq +
        sta $7F4103
        lda #0
        sta $7F4003

        lda $7F4116
        ora #%00000001
        sta $7F4116
        bra end_square0
+
        lda $7F4116
        and #%11111110
        sta $7F4116
        bra end_square0

decay_disabled0:
        lda $7F4003
        sta $7F4103

end_square0:

        lda $7F4004
        and #%00100000
        bne decay_disabled1

        lda $7F4007
        beq +
        sta $7F4107
        lda #0
        sta $7F4007

        lda $7F4116
        ora #00000010
        sta $7F4116
        bra end_square1
+
        lda $7F4116
        and #%11111101
        sta $7F4116
        bra end_square1

decay_disabled1:
        lda $7F4007
        sta $7F4107
end_square1:
                        ;       triangle wave
        lda $7F4008
        and #%10000000
        bne disabled3

        lda $7F400B
        beq +
        sta $7F410B
        lda #0
        sta $7F400B
        lda $7F4116
        ora #%00000100
        sta $7F4116
        bra end_tri
+
        lda $7F4116
        and #%11111011
        sta $7F4116
        bra end_tri

disabled3:
        lda $7F400B
        sta $7F410B
end_tri:

        lda $7F400C
        and #%00100000
        bne decay_disabled2

        lda $7F400F
        beq +
        sta $7F410F
        lda #0
        sta $7F400F

        lda $7F4116
        ora #%00001000
        sta $7F4116
        bra end_noise
+
        lda $7F4116
        and #%11110111
        sta $7F4116
        bra end_noise

decay_disabled2:
        lda $7F400F
        sta $7F410F
end_noise:
                        ; check freq for sweeps
        lda $7F4001
        and #%10000000
        beq sqsw1

        lda $7F4001
        and #%00000111
        beq sqsw1x
        lda $7F4002
        beq sqsw1
        sta $7F4102
        lda #0
        sta $7F4002
        lda $7F4116
        ora #%01000000
        sta $7F4116
        bra +


sqsw1:
        lda $7F4002
        sta $7F4102
+
        bra nextcheck
sqsw1x:
        lda $7F4116
        and #%10111111
        sta $7F4116
        bra sqsw1

nextcheck:

                        ; check freq for sweeps
        lda $7F4005
        and #%10000000
        beq sqsw12

        lda $7F4005
        and #%00000111
        beq sqsw1x2
        lda $7F4006
        beq sqsw12
        sta $7F4106
        lda #0
        sta $7F4006
        lda $7F4116
        ora #%10000000
        sta $7F4116
        bra +


sqsw12:
        lda $7F4006
        sta $7F4106
+
        bra nextcheck2
sqsw1x2:
        lda $7F4116
        and #%01111111
        sta $7F4116
        bra sqsw12

nextcheck2:


        rts
        
;=============================================

backup_regs:
        lda $7F4000
        sta $7F4100
        lda $7F4001
        sta $7F4101
;        lda $7F4002
;        sta $7F4102
        lda $7F4004
        sta $7F4104
        lda $7F4005
        sta $7F4105
;        lda $7F4006
;        sta $7F4106
        lda $7F4008
        sta $7F4108
        lda $7F4009
        sta $7F4109
        lda $7F400A
        sta $7F410A
;        lda $7F400B
;        sta $7F410B
        lda $7F400C
        sta $7F410C
        lda $7F400D
        sta $7F410D
        lda $7F400E
        sta $7F410E
;        lda $7F4015
;        sta $7F4115

        lda $7F4011
        sta $7F4111

        rts

;=============================================

emulate_length_counter:
        lda #0
        sta $7F4115
                                ; square 0
        lda $7F4116
        and #%00000001
        beq sq0_not_changed

        lda $7F4103        
        pha
        and #%00001000
        beq sq0_d3_0

        pla
        lsr a
        lsr a
        lsr a
        lsr a

        xba
        lda #0
        xba

        tax
        lda length_d3_1,x
        sta square0_length
        bra sq0_load_end

sq0_d3_0:
        pla
        lsr a
        lsr a
        lsr a
        lsr a

        tax
        lda length_d3_0,x
        sta square0_length        

sq0_load_end:

;        lda #0
;        sta $7F4003

sq0_not_changed:

        lda $7F4115
        ora #%00000001
        sta $7F4115

        lda $7F4000
        and #%00100000
        bne sq0_counter_disabled


        lda square0_length
        beq blahsq
        dec square0_length
        bra +
blahsq:
        lda $7F4115
        and #%11111110
        sta $7F4115

+
sq0_counter_disabled:
                                ; square 1
        lda $7F4116
        and #%00000010
        beq sq1_not_changed

        lda $7F4107
        pha
        and #%00001000
        beq sq1_d3_0

        pla
        lsr a
        lsr a
        lsr a
        lsr a

        xba
        lda #0
        xba

        tax
        lda length_d3_1,x
        sta square1_length
        bra sq1_load_end

sq1_d3_0:
        pla
        lsr a
        lsr a
        lsr a
        lsr a

        tax
        lda length_d3_0,x
        sta square1_length        

sq1_load_end:

;        lda #0
;        sta $7F4007

sq1_not_changed:

        lda $7F4115
        ora #%00000010
        sta $7F4115

        lda $7F4004
        and #%00100000
        bne sq1_counter_disabled

        lda square1_length
        beq sqblah
        dec square1_length
        bra +
sqblah:
        lda $7F4115
        and #%11111101
        sta $7F4115

+

sq1_counter_disabled:

                                ; triangle channel
        lda $7F4116
        and #%00000100
        beq tri_not_changed

        lda $7F410B
        pha
        and #%00001000
        beq tri_d3_0

        pla
        lsr a
        lsr a
        lsr a
        lsr a

        xba
        lda #0
        xba

        tax
        lda length_d3_1,x
        sta triangle_length
        bra tri_load_end

tri_d3_0:
        pla
        lsr a
        lsr a
        lsr a
        lsr a

        tax
        lda length_d3_0,x
        sta triangle_length        

tri_load_end:

;        lda #0
;        sta $7F400B

tri_not_changed:

        lda $7F4115
        ora #%00000100
        sta $7F4115

        lda $7F4008
        and #%10000000
        bne tri_counter_disabled

        lda triangle_length
        beq blah
        dec triangle_length
        bra +
blah:
        lda $7F4115
        and #%11111011
        sta $7F4115

+

tri_counter_disabled:

                                ; noise channel
        lda $7F4116
        and #%00001000          ; get length value (0 if unchanged)
        beq unchanged

        lda $7F410F
        pha
        and #%00001000
        beq d3_0

        pla
        lsr a
        lsr a
        lsr a
        lsr a

        xba
        lda #0
        xba

        tax
        lda length_d3_1,x
        sta noise_length

        bra load_end

d3_0:
        pla
        lsr a
        lsr a
        lsr a
        lsr a

        tax
        lda length_d3_0,x
        sta noise_length

load_end:
;        lda #0
;        sta $7F400F

unchanged:

        lda $7F4115
        ora #%00001000
        sta $7F4115

        lda $7F400C
        and #%00100000
        bne noise_counter_disabled

        lda noise_length
        beq pleh

        dec noise_length
        bra +

pleh:
        lda $7F4115
        and #%11110111
        sta $7F4115
+

noise_counter_disabled:

        lda $7F4115
        and $7F4015
        sta $7F4115

        rts

;length_counter_status:
;
;        lda noise_length
;        beq +
;        lda $7F4115
;        ora #%00001000
;        sta $7F4115
;        bra nyah
;
;+
;        lda $7F4115
;        and #%11110111
;        sta $7F4115
;nyah:
;
;        lda triangle_length
;        beq +
;        lda $7F4115
;        ora #%00000100
;        sta $7F4115
;        bra tyah
;+
;        lda $7F4115
;        and #%11111011
;        sta $7F4115
;tyah:
;
;        lda square0_length
;;        beq +
;        lda $7F4115
;        ora #%00000001
;;        sta $7F4115
;        bra syah
;;+
;        lda $7F4115
;        and #%11111110
;        sta $7F4115
;syah:
;
;        lda square1_length
;        beq +
;        lda $7F4115
;        ora #%00000010
;        sta $7F4115
;        bra myah
;+
;        lda $7F4115
;        and #%11111101
;        sta $7F4115
;myah:
;
;;        lda $7F4115
;;        and $7F4015
;        lda $7F4015
;        sta $7F4115
;
;        rts


length_d3_0:
        .db $06,$0B,$15,$29,$51,$1F,$08,$0F
        .db $07,$0D,$19,$31,$61,$25,$09,$11

length_d3_1:
        .db $80,$02,$03,$04,$05,$06,$07,$08
        .db $09,$0A,$0B,$0C,$0D,$0E,$0F,$10

;=============================================
proc_buttons:
        lda #up_button8         ; increment song
        and joy1+1
        beq +
        and joy1old+1
        bne +

        lda song
        cmp maxsong
        beq +

        lda #$2
        sta playspeed
        sta playspeed_count

        jsr clear_nes_ram

        lda #1
        sta $4200

        lda song
        inc a
        sta song
        
        jsl $7F5003
        phk
        plb
        lda #%10000001
        sta $4200       

+
        lda #down_button8       ; decrement song
        and joy1+1
        beq +
        and joy1old+1
        bne +

        ldx curr_screen
        cpx #323*9              ; robocop 2 no-crash hack
        bne waa
        lda song
        cmp #$40
        beq +
waa:
        cpx #265*9              ; mitokoumon no-crash hack
        bne waa2
        lda song
        cmp #5
        beq +

waa2:

        lda song
        beq +

        lda #$2
        sta playspeed
        sta playspeed_count

        jsr clear_nes_ram

        lda #1
        sta $4200

        lda song
        dec a
        sta song

        jsl $7F5003
        phk
        plb
        lda #%10000001
        sta $4200

+
        lda #right_button8      ; increment NSF
        and joy1+1
        beq +
        and joy1old+1
        bne +

        ldx curr_screen
        cpx #nsf_limit*9
        beq +

        lda #$2
        sta playspeed
        sta playspeed_count

        lda #0
        sta $7F4115
        jsr update_dsp
            
        xba
        lda #0
        xba

        rep #$20
.mem 16
        lda.w curr_screen
        clc
        adc #9
        sta.w curr_screen

        lda nsf
        clc
        adc #5
        sta nsf
        tax
        sep #$20
.mem 8
        stz status
        jsr unpack_nsf
        lda #1
        sta status

        lda #1
        sta $4200

        lda song

        jsl $7F5003
        phk
        plb
        lda #%10000001
        sta $4200

        clc
        lda $1241
        adc #8
        cmp #$C0+6
        bne samepagex

        rep #$20
.mem 16
        lda nsf_list_offset
        clc
        adc #$0300
        sta nsf_list_offset

        sep #$20
.mem 8
        lda #$06
samepagex:
        sta $1241


+
        lda #left_button8       ; decrement NSF
        and joy1+1
        beq +
        and joy1old+1
        bne +

        ldx.w curr_screen
        beq +

        lda #$2
        sta playspeed
        sta playspeed_count

        lda #0
        sta $7F4115
        jsr update_dsp

        xba
        lda #0
        xba

        rep #$20
.mem 16
        lda.w curr_screen
        sec
        sbc #9
        sta.w curr_screen
        lda nsf
        sec
        sbc #5
        sta nsf
        tax
        sep #$20
.mem 8
        stz status
        jsr unpack_nsf
        lda #1
        sta status

        lda #1
        sta $4200

        lda song

        jsl $7F5003
        phk
        plb
        lda #%10000001
        sta $4200

        sec
        lda $1241
        sbc #8
        cmp #$FE  
        bne samepage_y

        rep #$20
.mem 16
        lda nsf_list_offset
        sec
        sbc #$0300
        sta nsf_list_offset

        sep #$20
.mem 8
        lda #$BE
samepage_y:
        sta $1241



+
        lda #x_button8
        and joy1
        beq +
        and joy1old
        bne +

        ldx.w #$0800    ;#$0240
        lda #0
-
        sta regbits,x
        dex
        dex
        bne -
        sta regbits,x

        inc viewtype
        lda viewtype
        cmp #amount
        bne no_reset
        stz viewtype
no_reset:

+

        lda #a_button8
        and joy1
        beq +
        and joy1old
        bne +

        ldx.w #$0800    ;#$0240
        lda #0
-
        sta regbits,x
        dex
        dex
        bne -
        sta regbits,x

        dec viewtype
        lda viewtype
        cmp #$FF
        bne no_reset2
        lda #amount-1
        sta viewtype
no_reset2:
;        jmp no_reset2

+


        lda #select_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +

        jsr selection
        rts

+

        lda #start_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +

        lda #1
        sta $4200

        lda song
        jsl $7F5003
        phk
        plb
        lda #%10000001
        sta $4200

+

        lda #y_button8
        and joy1+1
        beq +
        and joy1old+1
        bne +

        lda $7F4116
        eor #$20
        sta $7F4116             ; toggle stereo/mono


+

        lda #l_button8
        and joy1
        beq +
        and joy1old
        bne +

        lda playspeed
        cmp #2
        beq +
        dec playspeed

+

        lda #r_button8
        and joy1
        beq +
        and joy1old
        bne +

        inc playspeed
        lda playspeed
        sta playspeed_count

+


        rts
        

;=============================================
update_dsp:
        php
.index 8
        sep #$10                
-
        lda $2140
        cmp #$7D                ; wait for SPC ready
        bne -

        lda #$D7
        sta $2140               ; tell SPC that CPU is ready
-
        cmp $2140               ; wait for reply
        bne -

        ldx #0
        stx $2140               ; clear port 0
xfer:
        lda $7F4100,x
        sta $2141               ; send data to port 1
-
        cpx $2140               ; wait for reply on port 0
        bne -

        inx
        cpx #$17
        beq +
        stx $2140
        bra xfer

+

.index 16
        plp
        rts

;=============================================
;       2A03 Register Monitor
;---------------------------------------------
                        ; this subroutine will display the bits being
                        ; written into the NES's sound registers
regmon:
        ldx.w #0
        ldy.w #0
        stz temp_lo

-
        lda $7F4000,x
        and #%10000000
        clc
        rol
        rol
        adc #$11
        sta regbits,y

        lda $7F4000,x
        and #%01000000
        rol
        rol
        rol
        adc #$11
        sta regbits+2,y

        lda $7F4000,x
        and #%00100000
        rol
        rol
        rol
        rol
        adc #$11
        sta regbits+4,y

        lda $7F4000,x
        and #%00010000
        lsr
        lsr
        lsr
        lsr
        clc
        adc #$11
        sta regbits+6,y

        lda $7F4000,x
        and #%00001000
        lsr
        lsr
        lsr
        clc
        adc #$11
        sta regbits+8,y

        lda $7F4000,x
        and #%00000100
        lsr
        lsr
        clc
        adc #$11
        sta regbits+10,y

        lda $7F4000,x
        and #%00000010
        lsr
        clc
        adc #$11
        sta regbits+12,y

        lda $7F4000,x
        and #%00000001
        clc
        adc #$11
        sta regbits+14,y

.mem 16
        rep #$20

        tya
        clc
        adc #$40
        tay
.mem 8
        sep #$20
        inx
        cpx #4
        bne +
        ldy.w #$0020
        brl -

+
        cpx #8
        bne +
        ldy.w #$0140
        brl -
+
        cpx #12
        bne +
        ldy.w #$0160
        brl -
+
        cpx #16
        beq +
        brl -
+
        rts



send_plasma_buffer:
        ldx.w #$3FFF
        stx $2116               ; dest. in VRAM
        lda #1
        sta $4300
        lda #$18
        sta $4301
        ldx.w #plasma_buffer    ; location
        stx $4302
        lda #$00                ; bank
        sta $4304
        ldx.w #$0C00            ; size
        stx $4305
        lda #1
        sta $420B


        rts





send_buffer:
        ldx.w #$40A4
        stx $2116               ; dest. in VRAM
        lda #1
        sta $4300
        lda #$18
        sta $4301
        ldx.w #regbits          ; location
        stx $4302
        lda #$00                ; bank
        sta $4304
        ldx.w #$0C00            ; size
        stx $4305
        lda #1
        sta $420B


        rts


;=============================================
setup_spc:
        php
        ldx.w #0
-
        lda spcprog,x
        sta $7E8000,x
        inx
;        cpx #8
        bne -

        lda #$00
        sta temp_long
        lda #$80
        sta temp_long+1
        lda #$7E
        sta temp_long+2

        lda #$8F
        sta $2100       ; screen off

        stz $4200       ; nmi disabled
        stz sentcount

        ldx.w #$0200
        stx sizecount_lo

        ldx.w #$BBAA
-
        cpx.w $2140
        bne -           ; wait for SPC to be ready

        ldx.w #$0400    ; start address for writing
        stx.w $2142

        lda #$01
        sta $2141       ; block

        lda #$CC        ; send load starter
        sta $2140
-
        lda $2140
        cmp #$CC
        bne -

        ldy.w #0
send256:
        lda [temp_long],y
        sta $2141               ; send byte
        iny
        lda sentcount
        sta $2140               ; send # sent
-
        cmp $2140
        bne -                   ; wait for SPC to reply with # sent

        ldx sizecount_lo
        dex
        stx sizecount_lo

        inc sentcount

;        lda sizecount_lo
        bne send256

        lda sentcount
-
        clc
        adc #3
        beq -

        sta sentcount

        bra debug

        lda sizecount_hi
        beq +

        lda #1
        sta $2141               ; block

        lda sentcount
        sta $2140
-
        cmp $2140
        bne -

;        lda #0
;        sta $2140
;-
;        lda $2140
;        bne -

        bra send256
+

debug:
                                ; send terminator block
        ldx.w #$0400
        stx.w $2142

        lda sentcount
        sta $2140
;        lda #0
        stz $2141
;        stz $2142
;        stz $2143

        plp
        rts


spcprog:
;        .dw 64
;        .dw $0400
;        .incbin "spc.obj"
;        .dw 64
;        .dw $0400

;---------------------------------------------
vblanknmi:
        pha
        phx
        php

        sep #$20
        rep #$10

        lda $4210

        lda status
        beq +
        jsr send_buffer
+
        plp
        plx
        pla
        rti
empty:
        rti

;---------------------------------------------------
check_buttons:        
-
        lda $4212
        and #%00000001
        bne -

        lda joy1
        sta joy1old
        lda joy1+1
        sta joy1old+1

        lda $4218
        sta joy1
        lda $4219
        sta joy1+1

        rts

;---------------------------------------------------
set_work_rasters:
        ldx.w #200           ; horizontal position to trigger IRQ (hblank?)
        stx $4207

        lda #%00010000          ; horizontal IRQ enabled
        sta $4200

        rts

        
;---------------------------------------------------
disable_work_rasters:

        lda #%10000001          ; enable joypad
        sta $4200

        jsr set_bg_black

        rts

;---------------------------------------------------
h_irq:
        phb
        pha
        php

;        rep #$10
        sep #$20

        lda #$00
        pha
        plb

        stz $2121

        lda $105D
        sta $2122
        lda $105E
        sta $2122

abort:

        lda $4211     ; clear interrupt

        plp
        pla
        plb
        rti

;---------------------------------------------------
banked:
        rep #$20
.mem 16
        lda $700008

        and.w #$0FFF
        clc
        adc.w #$8000
        sta load_addy

        tax

        phx

        lda $700070
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank0:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank0

        plx



        lda load_addy
        clc
        adc.w #$1000

;        and.w #$0FFF
        tax

        phx

        lda $700071
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank1:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank1

        plx     





        lda load_addy
        clc
        adc.w #$2000

;        and.w #$0FFF
        tax

        phx

        lda $700072
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank2:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank2

        plx     




        lda load_addy
        clc
        adc.w #$3000

;        and.w #$0FFF
        tax

        phx

        lda $700073
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank3:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank3

        plx     





        lda load_addy
        clc
        adc.w #$4000

;        and.w #$0FFF
        tax

        phx

        lda $700074
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank4:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank4

        plx     





        lda load_addy
        clc
        adc.w #$5000

;        and.w #$0FFF
        tax

        phx

        lda $700075
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank5:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank5

        plx     





        lda load_addy
        clc
        adc.w #$6000

;        and.w #$0FFF
        tax

        phx

        lda $700076
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank6:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank6

        plx     





        lda load_addy
        clc
        adc.w #$7000

;        and.w #$0FFF
        tax

        phx

        lda $700077
        and.w #$00FF
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        asl
        tax
        stx temp_lo
        ldy #$0800

load_bank7:
        ldx temp_lo
        lda $700080,x
        inx
        inx
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
;        txa
;        and #$F000
;        beq +
;        ldx #0
;+
        phx

        dey
        bne load_bank7

        plx



        sep #$20
.mem 8

;        jsr clear_nes_ram

        jmp bram_continue


;        nop
;        nop
;        nop
;        bra banked
                  
-
        nop
        bra -
        rts

bram_nsf:
        jsr clear_nes_sound
        jsr update_dsp
        
        jsr clear_nes_space
        jsr clear_wram

        
        lda $700000
        cmp #"N"
        bne -
        lda $700001
        cmp #"E"
        bne -
        lda $700002
        cmp #"S"
        bne -
        lda $700003
        cmp #"M"
        bne -

                                        ; NSF file is OK, check bankswitch presets
        ldx #0
-
        lda $700070,x
        beq +
        jmp banked
+
        inx
        cpx #8
        bne -


        rep #$20
.mem 16
        lda $700008
        sta load_addy
        tax

        phx
        ldx.w #0
-
        lda $700080,x
        stx temp_lo
        plx
        sta $7F0000,x
        inx
        inx
        phx
        ldx temp_lo
        inx
        inx
        cpx.w #$8000
        bne -

        plx

bram_continue:
        sep #$20
.mem 8

        ldx.w #0
-        
        lda nescode,x
        sta $7F5000,x
        inx
        cpx #$0100
        bne -

        lda $70000A
        sta init_lo
        lda $70000B
        sta init_hi

        lda $70000C
        sta play_lo
        lda $70000D
        sta play_hi

        lda $700006
        dec a
        sta maxsong

        lda $700007
        dec a
        sta song


        lda #$8F
        sta $2100

                        ; put NSF info fields on screen
        ldy.w #$4020
        sty.w $2116
        ldy.w #0
        tyx
.detect on
        sep #$20
-
        lda $70000E,x

        xba
        lda #$04
        xba

        rep #$20

        sta $2118

        sep #$20

.detect off

        inx
        iny
        cpy #96
        bne -


        lda #$0F
        sta $2100

        rts



testwait:
        jmp testwait



unpack_nsf:
        cpx #0
        bne +
        jmp bram_nsf
+
        lda nsf_table,x
        sta $65                 ; addr lo
        lda nsf_table+1,x
        sta $66                 ; addr hi
        lda nsf_table+2,x
        sta $67                 ; addr bank
        lda nsf_table+4,x       ; NSF load addr hi
        xba                     ; switch lo/hi of acc.
        lda nsf_table+3,x       ; NSF load addr lo
        tax                     ; xfer 16bit NSF load address
        stx $68                 ; address to unpack to
        stx load_addy




        jsr clear_nes_sound
        jsr update_dsp


        jsr clear_nes_space
        jsr clear_wram
        jsr set_work_rasters

        cli
        lda #$80
        sta $4211

        lda #$7F                ; bank to unpack to
        pha
        plb


        jsr UNPACK

.mem 8
        sep #$20
        phk
        plb

        sei
        lda #0
        sta $4211

        jsr disable_work_rasters

        ldx.w #0
-        
        lda nescode,x
        sta $7F5000,x
        inx
        cpx #$0100
        bne -

        ldx load_addy
        lda $7F000A,x
        sta init_lo
        lda $7F000B,x
        sta init_hi

        lda $7F000C,x
        sta play_lo
        lda $7F000D,x
        sta play_hi

        lda $7F0006,x
        dec a
        sta maxsong

        lda $7F0007,x
        dec a
        sta song

        
        lda #$8F
        sta $2100

                        ; put NSF info fields on screen
        ldy.w #$4020
        sty.w $2116
        ldy.w #0
.detect on
        sep #$20
-
        lda $7F000E,x

        xba
        lda #$04
        xba

        rep #$20

        sta $2118

        sep #$20

.detect off

        inx
        iny
        cpy #96
        bne -

        lda screenchange
        bne +

        ldx.w curr_screen
        jsr draw_screen
+

        lda #$0F
        sta $2100

        lda #1
        sta square0_length
        sta square1_length
        sta triangle_length
        sta noise_length


        rts


;----------------------------------------
note_table:     .include "notetabl.asm"
note_names:   .incbin "notename.bin" ; .include "notename.asm"
;---------------------------------------- * * * * * * * * * * * * * * * * *

;                               NSF addresses and load offsets (minus header)
nsf_table:

        .dl replay22
        .dw $8000

        .dl n1943
        .dw $7F80

;        .dl n1999              ; zero-page problem
;        .dw $7F80

        .dl n720
        .dw $7F80

        .dl n8_eyes                     ; hacked to perfection
        .dw $7F80

        .dl adventures_of_dino_riki
        .dw $AF80

        .dl adventure_island
        .dw $BF80

        .dl adv_of_lolo
        .dw $DC7D

        .dl adv_of_lolo2
        .dw $D323

        .dl adv_magic
        .dw $7F80

        .dl air_fortress
        .dw $D65F

        .dl air_kirameki
        .dw $8000

        .dl air_mikoto
        .dw $8000

        .dl air_wind
        .dw $8000

        .dl alfred_chicken
        .dw $7F80

        .dl algos
        .dw $9F55

        .dl alien_3
        .dw $7F83

        .dl alien_syndrome              ; hacked to perferction
        .dw $7F80

        .dl altered_beast              ; missing title screen
        .dw $7F82

        .dl al_unser_jr
        .dw $7F83

        .dl amagon                     ; crashes gamestation
        .dw $7F80

        .dl america
        .dw $7F80

        .dl antarctic_adventure
        .dw $F9F1

        .dl aressha
        .dw $EB80

        .dl argus
        .dw $EB24

        .dl arkanoid                    ; hacked to perfection
        .dw $DF80

        .dl arkanoid_2
        .dw $7F80

        .dl armed_dragon_fantasy        ; crashes sometimes
        .dw $7F80

        .dl asterix
        .dw $7F80

;        .dl astro_robo_sasa            ; bad rip?
;        .dw $AE85

;        .dl astyanax                   ; plays badly
;        .dw $8C85

;        .dl athena
;        .dw $7F80

;        .dl atlantis                   ; zero-page problem
;        .dw $C6A8

        .dl attack_of_the_killer_t
        .dw $8F80

        .dl autumn_theme
        .dw $8000

        .dl bad_dudes
        .dw $7F83

        .dl balloon_fight
        .dw $F3E0

        .dl balloon_fight_vs
        .dw $EF80

        .dl barbie
        .dw $8E95

        .dl bart_meets_radioactive
        .dw $7F80
        
        .dl bart_vs_space_mutants
        .dw $A3A0

        .dl bart_vs_the_world
        .dw $7F80

        .dl baseball_simulator
        .dw $7F88

        .dl baseball_stars
        .dw $7F80

        .dl baseball_stars_2
        .dw $7F80

;        .dl batsu_and_terii            ; zero-page problem
;        .dw $7F80

;        .dl battle_of_olympus
;        .dw $7F82

        .dl battle_toads
        .dw $7F80

        .dl battle_toads_and_dd
        .dw $7F80

        .dl bignose_freaks_out
        .dw $7F80

        .dl bignose_the_caveman
        .dw $7F80

        .dl big_trouble
        .dw $802E

        .dl bikkuriman_world
        .dw $9CEA

        .dl bionic_commando
        .dw $7F80

;        .dl bio_senshi_dan             ; zero-page problem - fix failed
;        .dw $CB92

;        .dl blaster_master
;        .dw $7F93                      ; zero-page problems

        .dl bokosuka_wars
        .dw $E162

        .dl bomber_man
        .dw $E41B

        .dl bonks_adventure
        .dw $7F80

        .dl booby_kids                 ; menu problem? fixed/nmi disable
        .dw $7F80

        .dl bram_stokers_dracula
        .dw $7F83

        .dl break_thru
        .dw $9780

;        .dl bubble_bobble              ; fucks w/ the stack
;        .dw $7F80

        .dl bughoney
        .dw $80C6

        .dl bump_n_jump
        .dw $B680

        .dl burai_fighter              ; hacked to perfection
        .dw $91DA

        .dl burgertime
        .dw $BF80

        .dl b_wing
        .dw $E300

        .dl caesars_palace
        .dw $7F80

        .dl captain_america
        .dw $7F86

        .dl castle_excellent
        .dw $B7C0

        .dl castlevania
        .dw $80FB

        .dl caverns
        .dw $8000

        .dl challenger
        .dw $BF70

        .dl chaos_world
        .dw $7F80

        .dl chip_and_dale
        .dw $7F80

        .dl chip_and_dale_2
        .dw $7F80

        .dl choujen_sentai_jetman
        .dw $7F80

        .dl chou_jikyu_macross
        .dw $C120

        .dl chousenjyo                 ; 1 gamestation crash
        .dw $AE80

        .dl chugoku
        .dw $7F80

        .dl circus_charlie
        .dw $BF80

        .dl city_connection
        .dw $9F80

        .dl clash_at_demonhead
        .dw $9F80

        .dl cluclu_land
        .dw $F6A0

        .dl cluclu_land_vs
        .dw $F400

        .dl cobra_command
        .dw $7F83

        .dl cobra_triangle
        .dw $86EB

        .dl cocoron
        .dw $7F80

        .dl codename_viper
        .dw $7F80

;        .dl comic_bakery               ; zero-page problems
;        .dw $7F80

        .dl commando
        .dw $7F80

        .dl conquest_of_crystal
        .dw $7F81

        .dl cool_world
        .dw $837C

        .dl cosmo_police_galivan
        .dw $7F80

        .dl covers_vol1
        .dw $7F80

        .dl cowboy_kid
        .dw $7F90

        .dl crazy_climber
        .dw $8194

        .dl daimashikyou_galious
        .dw $7F80

;        .dl daisenryaku                ; zero-page problem
;        .dw $7F80

        .dl daiva
        .dw $C493

;        .dl dance_of_the_sugarplum     ; zero-page problems
;        .dw $BF80

        .dl dark_city
        .dw $8000

        .dl darkwing_duck
        .dw $7F80

        .dl dauntaun_nekketsu
        .dw $7F80

;        .dl dds_megaten                ; zero-page problem
;        .dw $7F86

        .dl deadly_towers
        .dw $C816

        .dl deja_vu
        .dw $7F80

        .dl destiny_of_an
        .dw $7F80

        .dl destiny_of_an_2
        .dw $7F80

        .dl devil_world
        .dw $F6F0

;        .dl die_hard           ; zero-page problem
;        .dw $7F83

        .dl disk_system
        .dw $FDB0

        .dl dizzy_the_adventurer
        .dw $7F80

;        .dl dokuganryu                 ; zero-page problem
;        .dw $7F80

        .dl donald_duck
        .dw $7F80

;        .dl dondokodon         ; stack problem
;        .dw $7F80

        .dl dondokodon_2
        .dw $7F80

        .dl donkey_kong
        .dw $F9C8

        .dl donkey_kong_jr
        .dw $F800

        .dl donkey_kong_3
        .dw $F6E0

        .dl double_dragon
        .dw $7F80

        .dl double_dragon_2
        .dw $7F80

        .dl double_dragon_3
        .dw $7F80

        .dl dragon_ball
        .dw $7FC0

        .dl dragon_ball_2
        .dw $7FA1

        .dl dragon_ball_3
        .dw $7FA9

        .dl dragon_buster
        .dw $8F80

        .dl dragon_buster_2
        .dw $7F81

        .dl dragon_fighter
        .dw $7F90

;       .dl dragon_scroll              - needs de-bankswitched
;       .dw

        .dl dragons_lair
        .dw $7F89

        .dl dragon_slayer4
        .dw $8000

        .dl dragon_spirit
        .dw $7F80

        .dl dragon_unit
        .dw $8F81

        .dl dragon_warrior              
        .dw $EB80

        .dl dragon_warrior_2           ; hacked to perfection
        .dw $7F80

        .dl dragon_warrior_3           ; hacked to perfection
        .dw $7FC9

        .dl dr_jeckyll
        .dw $7F80

        .dl dropzone
        .dw $83E0

        .dl duck_hunt
        .dw $BF30

        .dl duck_hunt_vs
        .dw $BF20

        .dl duck_tales
        .dw $7F80

        .dl duck_tales_proto
        .dw $7F80

        .dl dungeon_magic
        .dw $7F90

;        .dl elevator_action            ; zero-page problem
;        .dw $EF80

        .dl elite
        .dw $7F8C

        .dl empire_city
        .dw $7F80

        .dl espa_bou
        .dw $8F40

        .dl euphory_town
        .dw $8000

        .dl excite_bike
        .dw $F700

        .dl excite_bike_vs
        .dw $BF20

        .dl f1_race
        .dw $F3EE

        .dl famicom_tantei_club
        .dw $7F80

        .dl family_circuit
        .dw $7F80

        .dl family_mahjong
        .dw $7F80

        .dl fantastic_dizzy
        .dw $84A2

        .dl fantasy_zone
        .dw $8F80

        .dl fantasy_zone_nes
        .dw $7FA0

        .dl fantasy_zone_2
        .dw $9780

;        .dl faria
;        .dw $E1B0

        .dl faxanadu
        .dw $7F80

        .dl ferrari_gp
        .dw $8099

        .dl fighting_golf
        .dw $7F80

        .dl final_fantasy
        .dw $7F80

        .dl final_fantasy_2
        .dw $9780

        .dl final_fantasy_3
        .dw $7F80

        .dl firehawk
        .dw $8181

        .dl fix_it
        .dw $8000

        .dl flappy
        .dw $B9F6

        .dl flintstones
        .dw $7F80

        .dl freedom_force
        .dw $7F80

        .dl friday_13th                ; crashes when not loaded first???
        .dw $F5FF

        .dl gallforce
        .dw $8000

        .dl gargoyles_quest_2
        .dw $7F80

        .dl garou_densetsu
        .dw $7F80

        .dl gauntlet
        .dw $7F83

        .dl gegege
        .dw $7F81

        .dl gekitotu
        .dw $7F85

        .dl genpei
        .dw $9E80

        .dl getsufuu
        .dw $7F80

;        .dl ghosts_n_goblins           ; zero-page problems
;        .dw $8300

        .dl goal_2
        .dw $7F9D

        .dl goemon
        .dw $7F80

        .dl goldrunner
        .dw $C0F1

        .dl goonies
        .dw $7F80

        .dl goonies_2
        .dw $7F80

        .dl gorilla_man
        .dw $7F80

;        .dl gotcha                     ; plays badly
;        .dw $7F80

        .dl gradius
        .dw $EBA8

        .dl greensleeves
        .dw $8000

        .dl guardian_legend
        .dw $90FC

        .dl guerilla_war
        .dw $7F80

;        .dl gumshoe                    ; JMP (xxxx) - unfixable
;        .dw $BF00

        .dl gunsmoke
        .dw $7F80

        .dl halloween
        .dw $7F80

        .dl hanjuku_hero
        .dw $7F80

        .dl heavy_barrel
        .dw $7F83

        .dl hector_87
        .dw $8505

        .dl heisei
        .dw $7F80

        .dl hercules
        .dw $99C0

        .dl hercules_2
        .dw $7F80

        .dl hero_quest
        .dw $7F80
           
        .dl high_speed
        .dw $8899

        .dl hinotori
        .dw $7F80

        .dl hogans_alley
        .dw $BF30

        .dl hogans_alley_vs
        .dw $BF30

        .dl home_alone_2
        .dw $7F80

        .dl homeland
        .dw $8000

        .dl hook
        .dw $7F80

        .dl hudson_hawk
        .dw $81C2

        .dl hyaku
        .dw $8F80

        .dl hydlide
        .dw $E08B

        .dl hydlide_3
        .dw $7F9F

        .dl hyper_olympic
        .dw $C080

        .dl hyper_sports
        .dw $C080

        .dl ice_climber
        .dw $F830

        .dl ice_climber_fds
        .dw $D300

        .dl ikari_warriors             ; hacked to perfection
        .dw $7F80

        .dl ikari_warriors_2           ; hacked to perfection
        .dw $7F80

;        .dl ikari_warriors_3           ; uses PCM
;        .dw $7F80

        .dl ikaruga
        .dw $8000

        .dl ike_ike
        .dw $7F80

        .dl ikki
        .dw $AA80

        .dl i_love_u
        .dw $8000

;        .dl image_fight                ; many stupid zero-page problems
;        .dw $7F80

        .dl incredible_crash_test
        .dw $7F80

        .dl indiana_jones
        .dw $7F80

        .dl insector_x
        .dw $7F83

        .dl iron_tank
        .dw $7F80

;        .dl isolated_warrior           ; wowo syndrome - fix failed
;        .dw $7F80

;        .dl itadaki_street             ; uses PCM
;        .dw $7F98

        .dl jackie_chan
        .dw $7F80

        .dl james_bond_jr
        .dw $7F80

;        .dl jesus                      ; many stupid zero-page problems
;        .dw $7F80

        .dl jetsons
        .dw $7F80

        .dl j_league
        .dw $7F80

        .dl jungle_book
        .dw $8F80


        .dl kabuki_quantum_fighter
        .dw $8C47

        .dl kachiuma
        .dw $7F80

        .dl kai
        .dw $9F84

;        .dl kaijuu                     ; zero-page problem - looks unfixable
;        .dw $7F80

        .dl kamen_rider_club
        .dw $7F85

        .dl karate_champ
        .dw $7F80

        .dl karate_kid                 ; hacked to perfection
        .dw $EE27

        .dl karnov
        .dw $9F80

        .dl kart_fighter
        .dw $7F80

        .dl k_demo2
        .dw $8000

        .dl keiba_simulation
        .dw $7F88

        .dl keru
        .dw $9F90

        .dl kickle_cubicle
        .dw $7F80

        .dl kid_icarus                 ; hacked to perfection!
        .dw $9F80

        .dl kiken
        .dw $BF83

        .dl king_kong                   ; hacked to perfection
        .dw $7F80

        .dl kings_knight                ; hacked to perfection
        .dw $BAF9

;        .dl kinnikuman                 ; m.u.s.c.l.e.
;        .dw $ACC0

        .dl kiwi_kraze
        .dw $7F80

        .dl klash_ball
        .dw $7F90

        .dl krion_conquest
        .dw $7F80

        .dl kung_fu
        .dw $DA00

;        .dl labyrinth                  ; zero-page problem
;        .dw $7F80

        .dl lassalle
        .dw $9F8C

        .dl last_armageddon
        .dw $7F80

;        .dl legacy_of_the_wizard       ; some kind of problem?
;        .dw $7F80

        .dl legendary_wings
        .dw $8F80

;        .dl legend_of_kage             ; zero-page problem
;        .dw $BF80

        .dl legend_of_zelda
        .dw $8CE0

        .dl lemmings
        .dw $7F80

        .dl lifeforce
        .dw $7F80

        .dl linus_spacehead
        .dw $7F80

        .dl little_mermaid
        .dw $7F80

        .dl little_nemo
        .dw $7F80

        .dl little_samson
        .dw $7F80

        .dl mach_rider
        .dw $EA14

        .dl magic_darts
        .dw $BF83

        .dl magic_johnson
        .dw $7F80

;        .dl magic_of_schez             ; zero-page problems
;        .dw $7F80

        .dl magmax
        .dw $F980

        .dl mahjong
        .dw $FC80

;        .dl majin                      ; uses PCM
;        .dw $7F86

        .dl makaijima
        .dw $7F80

        .dl mappy
        .dw $F390

        .dl marble_madness
        .dw $7F80

        .dl mario_bros
        .dw $F3F0

        .dl maze_of_galious_2
        .dw $7F80

        .dl mc_kids
        .dw $7FB4

        .dl megaman
        .dw $8F80

        .dl megaman_2
        .dw $7F80

        .dl megaman_3
        .dw $7F80

        .dl megaman_4
        .dw $7F80

        .dl megaman_5
        .dw $7F80

        .dl megaman_6
        .dw $7F80

        .dl micro_machines
        .dw $7F81

        .dl mig_29
        .dw $7F80

        .dl might_and_magic
        .dw $7F83

        .dl mighty_bomb_jack
        .dw $8CFA

        .dl mighty_final_fight
        .dw $7F80

        .dl mike_tyson
        .dw $7F80
       
        .dl millon
        .dw $EC80

;        .dl minelvaton         ; zero-page problems
;        .dw $A5C2

        .dl mississippi
        .dw $B770

        .dl mitokoumon
        .dw $7F8C

        .dl mizuskou
        .dw $7F80

        .dl moero
        .dw $C917

        .dl moon_crystal
        .dw $7F80

        .dl mouser
        .dw $7F97

        .dl muscle             ; hacked to perfection
        .dw $ACC0

        .dl my_island_dream
        .dw $8000

        .dl nadia
        .dw $7F80

        .dl nekketsu_koukou
        .dw $7F80

        .dl neutopia
        .dw $8000

        .dl nfl                        ; hacked to perfection
        .dw $7F80

        .dl nigel_mansell
        .dw $8016

        .dl nightmare_on_elm_street
        .dw $7F89

        .dl ninja_hattori
        .dw $C010

;        .dl ninja_kun_asyura           ; zero-page problems
;        .dw $7F80

        .dl nuts_and_milk
        .dw $EE80

        .dl obake_no_q
        .dw $C89A

;        .dl ohotsuku                   ; zero-page problems
;        .dw $7F80

;        .dl onyanko_town               ; stops for some reason?
;        .dw $C780

        .dl operation_wolf
        .dw $BF80

        .dl over_horizon
        .dw $7F80

        .dl overlord
        .dw $7F83

        .dl pacmania
        .dw $7F82

;        .dl parallel_world             ; stupid zero-page problems
;        .dw $8F80

        .dl parasol_stars
        .dw $9389

        .dl pictionary
        .dw $7F80

        .dl pinball
        .dw $BF30

        .dl pinball_vs
        .dw $BF10

        .dl pizza_pop
        .dw $7F80

        .dl platoon
        .dw $CF80

        .dl po_barabanu
        .dw $8000

        .dl pocket_zaurus
        .dw $8F89

        .dl pooyan
        .dw $DF80

        .dl popeye
        .dw $F3D0

        .dl pow
        .dw $7F80

;        .dl predator                   ; zero-page problems
;        .dw $7F83               

        .dl prince_of_persia            ; hacked to perfection
        .dw $A999

        .dl princess_tomato
        .dw $7F80

;        .dl pro_wrestling
;        .dw $5F80

;        .dl puzznic
;        .dw $BF80

        .dl quattro_adv_boomerang
        .dw $845D

        .dl quattro_adv_linus
        .dw $96E0

        .dl quattro_adv_robin_hood
        .dw $7F81

        .dl quattro_adv_treasure
        .dw $7F81

        .dl quattro_arcade_cjs
        .dw $7F81

        .dl quattro_arcade_f15_renegade
        .dw $9ECC

        .dl quattro_arcade_go_dizzy
        .dw $7F81

        .dl quattro_arcade_stunt_buggy
        .dw $7F81

        .dl quattro_sports_baseball
        .dw $A945

        .dl quattro_sports_soccer
        .dw $883D

        .dl radia
        .dw $7F80

        .dl rad_racer
        .dw $C588

        .dl raid_on_bungling_bay
        .dw $C100

;        .dl rainbow_island             ; doesn't play - can crash
;        .dw $7F80

        .dl rampage
        .dw $7F83

        .dl rbi_baseball
        .dw $A0A9

        .dl rc_proam
        .dw $7F90

        .dl rc_proam2
        .dw $9CBD

        .dl ren
        .dw $7F80

        .dl renegade
        .dw $7F80

        .dl rescue_the_embassy
        .dw $7F80

        .dl river_city_ransom
        .dw $7F80

        .dl rmadillo
        .dw $7F80

        .dl road_fighter
        .dw $BF80

        .dl robocco_wars
        .dw $7F80

        .dl robocop
        .dw $7F83

        .dl robocop_2
        .dw $7F8C

        .dl robocop_3
        .dw $7F80

        .dl robot_block
        .dw $BF80

        .dl robot_gyro
        .dw $EF00

        .dl robo_warrior
        .dw $7F8D

        .dl rockin_kats
        .dw $86FB

        .dl roller_ball
        .dw $7F80

;        .dl rolling_thunder            ; hacked to perfection
;        .dw $7F80                      ; whoops, jap. ext. sound version

        .dl romancia
        .dw $7F81

        .dl romsaga1_8
        .dw $8000

        .dl romsaga1_10
        .dw $8000

        .dl romsaga1_11
        .dw $8000

        .dl romsaga1_14
        .dw $8000

        .dl romsaga2_3
        .dw $8000

        .dl rophons_theme
        .dw $8000

        .dl ropm2001_09_29
        .dw $8000

        .dl ropm2002_06_11
        .dw $8000

        .dl route_16_turbo
        .dw $7F80

        .dl rush_n_attack
        .dw $7F88

        .dl rygar
        .dw $DF56

        .dl saint_sei
        .dw $A498

        .dl sanma
        .dw $9FD2

;        .dl sd_keiji_blader
;        .dw $7F80

        .dl section_z
        .dw $7F80

        .dl shadowed
        .dw $8000

        .dl shadowgate
        .dw $7F80

        .dl shadow_of_the_ninja
        .dw $9F80

        .dl shancara
        .dw $7F80

        .dl shanghai
        .dw $7F80

        .dl tokkyuu_solbrain ; Shatterhand
        .dw $7F80

        .dl shen_huo
        .dw $BF80

        .dl shikinjou           ; needs screenshot
        .dw $7F80

        .dl shinjuku            ; needs screenshot
        .dw $7F80

        .dl shinobi             ; JMP (xxxx) - hacked to perfection
        .dw $9E32

        .dl shooting_range             ; hacked to perfection
        .dw $A767

        .dl shoukoushi
        .dw $7F95

        .dl side_pocket         ; hacked to perfection
        .dw $9A47

;        .dl silva_saga         ; weird problems
;        .dw $7F80

        .dl silver_surfer
        .dw $7F83

        .dl sky_kid
        .dw $A111

        .dl sky_shark
        .dw $8DC2

        .dl smurfs
        .dw $7F80

        .dl snow_bros
        .dw $7F80

        .dl soccer
        .dw $F420

        .dl solar_jetman
        .dw $A2A1

        .dl solomons_key
        .dw $EF6B

        .dl solstice
        .dw $8053

        .dl somari
        .dw $7F80

        .dl soshite
        .dw $8000

        .dl space_harrier      ; hacked to perfection
        .dw $7F81

        .dl space_shadow
        .dw $BF80

        .dl space_shuttle
        .dw $A580

        .dl spartan_x_2
        .dw $7F98

        .dl spelunker
        .dw $D780

        .dl spiderman
        .dw $9F80

        .dl splatterhouse
        .dw $9FB9

        .dl spy_hunter
        .dw $BFC5

;        .dl star_force
;        .dw $E580

        .dl star_force_eng
        .dw $EF70

        .dl star_luster
        .dw $E180

        .dl star_soldier
        .dw $7F80

        .dl star_trek_tng
        .dw $7F80

        .dl star_tropics_2
        .dw $9F80

        .dl sted
        .dw $7F83

        .dl stinger
        .dw $8983

        .dl street_fighter_2010
        .dw $7F80

        .dl strider
        .dw $7F80

;       Super Donkey Kong - needs de-bankswitched

;        .dl super_mario
;        .dw $BD44

        .dl super_mario_2
        .dw $7F80

        .dl super_star_force
        .dw $7FA8

        .dl super_xevious
        .dw $7F80

        .dl swamp_thing
        .dw $7F80

        .dl sweet_home
        .dw $7F80

        .dl swords_and_serpents        ; JMP ($00xxxx)
        .dw $7F80

        .dl tag_team_wrestling
        .dw $9B79

        .dl taito_gp
        .dw $7F80

;        .dl takeshi
;        .dw $7F89

        .dl talespin
        .dw $7F80

        .dl target_renegade
        .dw $7F8C

        .dl tecmo_soccer
        .dw $DA10

        .dl tecmo_world_cup
        .dw $7F80

        .dl tecmo_world_wrestling
        .dw $D140

        .dl terminator_2
        .dw $7F80

        .dl terra_cresta
        .dw $8050

        .dl terra_cresta_u
        .dw $7F80

;        .dl tetris_bps
;        .dw $BBA2

        .dl tetris
        .dw $7F80

        .dl tetris_tengen
        .dw $CF64

;        .dl tetris_flash
;        .dw $7F81

;        .dl tetris_2_and_bombliss              ; tricky
;        .dw $7F80

;        .dl tiger_heli
;        .dw $DB9B

        .dl time_zone
        .dw $7F80

        .dl tokaido                             ; hacked to perfection
        .dw $D6E0

        .dl tom_and_jerry
        .dw $7F80

        .dl tombs_and_treasures                 ; hacked to perfection
        .dw $7F80

        .dl top_striker
        .dw $7F80

;        .dl totally_rad
;        .dw $7F80

        .dl total_recall
        .dw $7F82

        .dl touch_down_fever
        .dw $7F80

        .dl toukon_club
        .dw $7F80

        .dl tower_of_babel
        .dw $EF80

        .dl tower_of_druaga                     ; hacked to perfection
        .dw $87F6

        .dl toxic_crusaders                     ; hacked to perfection
        .dw $810D

        .dl transformers
        .dw $7F84

        .dl treasure_master
        .dw $7F80

        .dl trojan
        .dw $9F00

        .dl tsuppari
        .dw $7F80

        .dl twinbee
        .dw $7F80

;        .dl twin_cobra                 ; zero-page problems
;        .dw $7F83

        .dl ultima_exodus
        .dw $7F80

;        .dl ultima_2                   ; noise channel weirdness??
;        .dw $7FBF

        .dl uncharted_waters
        .dw $7F80

        .dl uninvited
        .dw $7F80

        .dl urban_champion
        .dw $BF80

        .dl ushio
        .dw $7F80

        .dl valkyrie
        .dw $A0EA

        .dl vball
        .dw $7F80

        .dl venus
        .dw $7F81

        .dl vice
        .dw $7F80

        .dl volgard_2
        .dw $AD80

;        .dl wacky_race                 ; already in there under diff. name?
;        .dw $7F82

        .dl wagan_land                  ; bastardly!
        .dw $7F80

        .dl wagan_land_2                ; hacked to perfection
        .dw $7F80

        .dl wild_gunman                ; hacked to perfection
        .dw $BF30

        .dl willow
        .dw $7F80

        .dl wily_and_light
        .dw $7F80

        .dl winglancer_area_1
        .dw $8000

        .dl winglancer_area_2
        .dw $8000

        .dl winglancer_area_3
        .dw $8000

        .dl winglancer_area_4
        .dw $8000

        .dl winglancer_area_5
        .dw $8000

        .dl winglancer_boss_1
        .dw $8000

        .dl winglancer_boss_2
        .dw $8000

        .dl winglancer_bossmode
        .dw $8000

;        .dl wings_of_madoola           ; music stops?
;        .dw $F040

        .dl wizardry
        .dw $7F83

        .dl wizardry_knight
        .dw $8320

        .dl wizardry_legacy
        .dw $831F

        .dl wizards_and_warriors
        .dw $EBEF

        .dl wizards_and_warriors_2
        .dw $7F80

        .dl wizards_and_warriors_3
        .dw $7F80

        .dl wolverine
        .dw $7F83

        .dl world_champ
        .dw $7F80

        .dl wrecking_crew              ; hacked to perfection
        .dw $EF83

        .dl wrecking_crew_vs           ; hacked to perfection
        .dw $7F80

        .dl wurm
        .dw $7F80

        .dl wwf_wrestlemania
        .dw $7F98

        .dl wwf_wrestlemania_challenge
        .dw $7F80

        .dl xenon
        .dw $8000

        .dl xenophobe
        .dw $7F80

;        .dl xexyz
;        .dw $C345

        .dl yie_ar_kung_fu
        .dw $BF80

;        .dl yokohama                   ; doesn't play
;        .dw $7FA3

        .dl yo_noid
        .dw $7F80

        .dl yoshis_cookie
        .dw $8080

;        .dl youkai      ; (namco) needs de-bankswitched
;        .dw $

        .dl ys
        .dw $7F80

        .dl ys_2
        .dw $7F80

        .dl ys_3
        .dw $7F80

        .dl ys_pod
        .dw $8000

        .dl yuu_maze
        .dw $7FFC

        .dl yuu_yuu_hakusho
        .dw $7F80

        .dl zanac
        .dw $E980

        .dl zelda_2
        .dw $7F85

        .dl zelda_end
        .dw $8000

        .dl zeta_gundam
        .dw $EF80

        .dl zombie_hunter
        .dw $BF83

;---------------------------------------------------
;**
draw_screen:
.detect on
        php
        rep     #$10            ; X,Y fixed -> 16 bit mode
        sep     #$20            ; Accumulator ->  8 bit mode

        lda rnc_table,x
        sta $65
        lda rnc_table+1,x
        sta $66
        lda rnc_table+2,x
        sta $67
        stx temp_lo
        ldx.w #$A000
        stx $68
        lda #$7E
        pha
        plb
        jsr UNPACK

        sep #$20        

        phk
        plb


        ldx temp_lo

        lda rnc_table+3,x
        sta $65
        lda rnc_table+4,x
        sta $66
        lda rnc_table+5,x
        sta $67
        stx temp_lo
        ldx.w #$E000
        stx $68
        lda #$7E
        pha
        plb
        jsr UNPACK

        sep #$20
        
        phk
        plb

        jsr dma_tiles

        stz $2121               ; write palette
        ldx temp_lo
        lda rnc_table+6,x
        sta temp_long           ; addr_lo
        lda rnc_table+7,x
        sta temp_long+1         ; addr_hi
        lda rnc_table+8,x
        sta temp_long+2         ; bank byte
        stz temp_lo
-        
        lda [temp_long]           ; indirect long
        sta $2122
        inc temp_long
        inc temp_lo
        lda temp_lo
        cmp #32
        bne -

        jsr write_main_pal

        jsr dma_chrset

        plp

        rts


;        ldx     #!Picture                ; CRUNCHED FILE
;        stx     $65
;        phk
;        pla
;        ;lda    #^Picture1              ; CRUNCHED FILE BANK
;        sta     $67
;        ;ldx     #!UnpackBuffr            ; LOW WORD UNPACK BUFFER
;        ldx.w #!$8000
;        stx     $68
;        ;lda     #^UnpackBuffr           ; UNPACK BUFFER BANK
;        lda #$7E
;        pha
;        plb
;        jsr     UNPACK                          ;Requires A[8] XY[16]
;
;        phk
;        plb
;
;;        jsr dma_chrset
;;        rts


.detect off

;---------------------------------------------------
;               wait for 1 frame
;vblank:
;        lda $4212
;        bpl vblank
;        lda $4212               ; reset it
;        rts
;
;------------------------------------------------------------

;.include "c:\snes\clrvram.asm"
;.include "c:\snes\initsnes.asm"
.include "snesinit.txt"
.include "sound.asm"

;------------------------------------------------------------
clear_bram:
        lda $707D70
        cmp #$DE
        bne +
        lda $707D71
        cmp #$AD
        bne +

        lda #1
        sta bram_ok
        rts
+
        ldx.w #$0000
        lda #0
clear:        
        sta $700000,x
        inx
        cpx #$8000
        bne clear

        lda #$DE
        sta $707D70
        lda #$AD
        sta $707D71

        stz bram_ok
        rts
;------------------------------------------------------------
clear_wram:
        ldx.w #$8000
        lda #0
-
        sta $7E0000,x
        inx
        bne -
        rts
;------------------------------------------------------------
clear_ram:
        php
        sep #$30
.mem 16
        ldx.w #0
        txa
clear1:
        sta $0000,x
        inx
        inx
        cpx.w #$2000
        bne clear1

        ldx.w #$8000
clear2:
        sta $7E0000,x
        inx
        inx
        bne clear2

        tax
clear3:
        sta $7F0000,x
        inx
        inx
        bne clear3
        plp
.mem 8
        rts


;--=-=-=-=-=-=-=-        

        lda #$00
        pha
        plb
        
        ldx.w #0
-        
        stz $0000,x
        inx
        cpx #$0100
        bne -
        ldx.w #$0200
-
        stz $0000,x
        inx
        cpx #$2000
        bne -

        lda #$7E
        pha
        plb

        ldx.w #$8000
-
        stz $0000,x
        inx
        bne -

        lda #$7F
        pha
        plb

        ldx.w #$0000
-
        stz $0000,x
        inx
        bne -

        
        phk
        plb

        rts
;------------------------------------------------------------
clear_vram:
        php

        rep #$30
.mem 16

        ldx.w #0
        txa
        stx $2116
-
        sta $2118
        inx
        inx
        bne -

        plp
.mem 8
        rts

;------------------------------------------------------------
dma_tiles:
        ldx.w #$0000
        stx $2116
        lda #1
        sta $4300
        lda #$18
        sta $4301
        ldx.w #testmap&$FFFF
        stx $4302
        lda #testmap/$10000
        sta $4304
        ldx.w #2048
        stx $4305
        lda #1
        sta $420B

;        lda #0
;        sta $2121
;        ldx.w #$2200
;        stx $4300
;        ldx.w #testcol&$FFFF
;        stx $4302
;        ldx.w #testcol/$10000
;        stx $4304
;        ldx.w #32
;        stx $4305
;        lda #1
;        sta $420B

        rts

dma_chrset:
        ldx.w #$1000
        stx $2116
        lda #1
        sta $4300
        lda #$18
        sta $4301
        ldx.w #testset&$FFFF
        stx $4302
        lda #testset/$10000
        sta $4304
        ldx.w #16384   ;#14656
        stx $4305
        lda #1
        sta $420B

        ldx.w #$6000
        stx $2116
        lda #1
        sta $4300
        lda #$18
        sta $4301
;        ldx.w #phont&$FFFF
        ldx.w #0
        stx $4302
;        lda #phont/$10000
        lda #$C0
        sta $4304
        ldx.w #8192 ;12288        ;       ldx.w #8192
        stx $4305
        lda #1
        sta $420B

        ldx.w #$D000
        stx $2116
        lda #1
        sta $4300
        lda #$18
        sta $4301
        ldx.w #phont2&$FFFF
        stx $4302
        lda #phont2/$10000
        sta $4304
        ldx.w #2048
        stx $4305

        lda #1
        sta $420B

        rts

;------------------------------------------------------------
clear_nes_space:
        php
.mem 16
        rep #$30
        ldx.w #0
        lda $7F4116
        pha
        txa
-
        sta $7F0000,x
        inx
        inx
        bne -
        pla
        and #$20
        sta $7F4116

;        ldx.w #$0200
;-
;        sta $7F0000,x
;        inx
;        inx
;        cpx #$0800
;        bne -

        tdc
        pha

        lda.w #$0000
        tcd

        tax
-
        sta $00,x
        inx
        inx
        cpx #$0100
        bne -

        pla
        tcd


        plp
        rts

;------------------------------------------------------------
clear_nes_ram:
        php
.mem 16
        rep #$30
        ldx.w #0
        txa
-
        sta $7F0000,x
        inx
        inx
        cpx #$0800
        bne -

        jsr clear_nes_sound

        tdc
        pha

        lda.w #$0000
        tcd
        tax
-
        sta $00,x
        inx
        inx
        cpx #$0100
        bne -

        pla
        tcd

        plp
        rts        


;------------------------------------------------------------
clear_nes_sound:

;        lda.w #0  
        sta $7F4100             ; optimized for speeeeeed
        sta $7F4101
        sta $7F4102
        sta $7F4103
        sta $7F4104
        sta $7F4105
        sta $7F4106
        sta $7F4107
        sta $7F4108
        sta $7F4109
        sta $7F410A
        sta $7F410B
        sta $7F410C
        sta $7F410D
        sta $7F410E
        sta $7F410F
        sta $7F4114
        sta $7F4000
        sta $7F4001
        sta $7F4002
        sta $7F4003
        sta $7F4004
        sta $7F4005
        sta $7F4006
        sta $7F4007
        sta $7F4008
        sta $7F4009
        sta $7F400A
        sta $7F400B
        sta $7F400C
        sta $7F400D
        sta $7F400E
        sta $7F400F
        sta $7F4014

        rts

;------------------------------------------------------------
copy_tiles:
.mem 16        
.index 16
        rep #$30
        ldx.w #$0000
        stx $2116
        ldx.w #$0000
-        
        lda bitfont,x
        sta $2118
        inx
        inx
        cpx #$2000
        bne -

        ldx.w #$4000
        stx $2116
        ldx.w #$0000
-
        lda bitmap,x
        sta $2118
        inx
        inx
        cpx #$0800
        bne -
        
.mem 8        
        sep #$20
        
        lda #$00
        stx $2107       ; plane 0 tile location
        ldx #$04
        stx $210B       ; plane 0 map location


        ldx #0
        txa
        sta $2121
-
        lda colortest,x
        sta $2122
        inx
        cpx #32
        bne -
        
        rts
;------------------------------------------------------------
pixelfade:

        ldy.w #3
        ldx.w #17
pixeloop:
        wai
;        jsr vblank
        dey
        bne pixeloop

        ldy.w #3

        lda pixelize,x
        sta $2106

        dex
        bne pixeloop

        rts

pixelize:
        .db 0
        .db 0
        .db %00001111
        .db %00011111
        .db %00101111
        .db %00111111
        .db %01001111
        .db %01011111
        .db %01101111
        .db %01111111
        .db %10001111
        .db %10011111
        .db %10101111
        .db %10111111
        .db %11001111
        .db %11011111
        .db %11101111
        .db %11111111
;------------------------------------------------------------
set_bg_black:
        lda #$40
-
        bit $4212
        bne -
        
        stz $2121
        stz $2122
        stz $2122

        rts


set_bg_black2:
        lda #$40
-
        bit $4212
        bne -
        
        stz $2121
        stz $2122
        stz $2122
        lda #$0F
        sta $2100

        rts


set_bg_nsf:
        lda #$40
-
        bit $4212
        bne -

        stz $2121
        lda #%00011111
        sta $2122
        stz $2122
        lda #$0C
        sta $2100

        rts



;------------------------------------------------------------



;---------------------------------------------------------
; PRO-PACK Unpack Source Code - Super NES, Method 1
;
; Copyright (c) 1992 Rob Northen Computing
;
; File: RNC_1.S
;
; Date: 9.03.92
;---------------------------------------------------------
;---------------------------------------------------------
; Unpack Routine - Super NES, Method 1
;
; To unpack a packed file (in any data bank) to an output
; buffer (in any data bank) Note: the packed and unpacked
; files are limited to 65536 bytes in length.
;
; To call (assumes 16-bit accumulator)
;
;
; On exit,
;
; A, X, Y undefined, M=0, X=0
;---------------------------------------------------------
;---------------------------------------------------------
; Equates
;---------------------------------------------------------


;---------------------------------------------------------
.detect on
UNPACK  rep     #$39    ; 16-bit AXY, clear D and C
        lda     #Buff2
        sta     wrkbuf
        lda     #^Buff2
        sta     wrkbuf+2
        lda     #17
        adc     in
        sta     in
        lda     [in]
        and     #$00ff
        sta     blocks
        inc     in
        lda     [in]
        sta     bitbufl
        stz     bufbits
        lda     #2
        jsr     gtbits
unpack2 ldy     #rawtab
        jsr     makehuff
        ldy     #postab
        jsr     makehuff
        ldy     #slntab
        jsr     makehuff
        lda     #16
        jsr     gtbits
        sta     counts
        jmp     unpack8
unpack3 ldy     #postab
        jsr     gtval
        sta     temp2
        lda     out
        clc
        sbc     temp2
        sta     temp3
        ldy     #slntab
        jsr     gtval
        inc     a
        inc     a
        lsr     a
        tax
        ldy     #0
        lda     temp2
        bne     unpack5
        sep     #$20    ; 8-bit accumulator
        lda     (temp3),y
        xba
        lda     (temp3),y
        rep     #$20    ; 16-bit accumulator
unpack4 sta     (out),y
        iny
        iny
        dex
        bne     unpack4
        bra     unpack6
unpack5 lda     (temp3),y
        sta     (out),y
        iny
        iny
        dex
        bne     unpack5
unpack6 bcc     unpack7
        sep     #$20    ; 8-bit accumulator
        lda     (temp3),y
        sta     (out),y
        iny
        rep     #$21    ; 16-bit accumulator, clear carry
unpack7 tya
        adc     out
        sta     out
unpack8 ldy     #rawtab
        jsr     gtval
        tax
        beq     unpack14
        ldy     #0
        lsr     a
        beq     unpack10
        tax
unpack9 lda     [in],y
        sta     (out),y
        iny
        iny
        dex
        bne     unpack9
unpack10        bcc     unpack11
        sep     #$20    ; 8-bit accumulator
        lda     [in],y
        sta     (out),y
        rep     #$21    ; 16-bit accumulator, clear carry
        iny
unpack11        tya
        adc     in
        sta     in
        tya
        adc     out
        sta     out
        stz     bitbufh
        lda     bufbits
        tay
        asl     a
        tax
        lda     [in]
        cpy     #0
        beq     unpack13
unpack12        asl     a
        rol     bitbufh
        dey
        bne     unpack12
unpack13        sta     temp1
        phb
        phk
        plb
        lda     msktab,x                ;>
        plb
        and     bitbufl
        ora     temp1
        sta     bitbufl
unpack14        dec     counts
        beq     +
        jmp     unpack3
+       dec     blocks
        beq     +     
        jmp     unpack2
+       rts
;-----------------------------------------------------------
gtval   ldx     bitbufl
        bra     gtval3
gtval2  iny
        iny
gtval3  txa
        and     [wrkbuf],y
        iny
        iny
        cmp     [wrkbuf],y
        bne     gtval2
        tya
        adc     #(15*4+1)
        tay
        lda     [wrkbuf],y
        pha
        xba
        and     #$ff
        jsr     gtbits
        pla
        and     #$ff
        cmp     #2
        bcc     gtval4
        dec     a
        asl     a
        pha
        lsr     a
        jsr     gtbits
        plx
        phb
        phk
        plb
        ora     bittab,x                ;>
        plb
gtval4  rts
bittab  .dw   1
        .dw   2
        .dw   4
        .dw   8
        .dw   $10
        .dw   $20
        .dw   $40
        .dw   $80
        .dw   $100
        .dw   $200
        .dw   $400
        .dw   $800
        .dw   $1000
        .dw   $2000
        .dw   $4000
        .dw   $8000
;-----------------------------------------------------------
gtbits  tay
        asl     a
        tax
        phb
        phk
        plb
        lda     msktab,x                ;>
        plb
        and     bitbufl
        pha
        lda     bitbufh
        ldx     bufbits
        beq     gtbits3
gtbits2 lsr     a
        ror     bitbufl
        dey
        beq     gtbits4
        dex
        beq     gtbits3
        lsr     a
        ror     bitbufl
        dey
        beq     gtbits4
        dex
        bne     gtbits2
gtbits3 inc     in
        inc     in
        lda     [in]
        ldx     #16
        bra     gtbits2
gtbits4 dex
        stx     bufbits
        sta     bitbufh
        pla
gtbits5 rts
msktab  .dw   0
        .dw   1
        .dw   3
        .dw   7
        .dw   $f
        .dw   $1f
        .dw   $3f
        .dw   $7f
        .dw   $ff
        .dw   $1ff
        .dw   $3ff
        .dw   $7ff
        .dw   $fff
        .dw   $1fff
        .dw   $3fff
        .dw   $7fff
        .dw   $ffff
;-----------------------------------------------------------
makehuff        sty     temp4
        lda     #5
        jsr     gtbits
        beq     gtbits5
        sta     temp1
        sta     temp2
        ldy     #0
makehuff2       phy
        lda     #4
        jsr     gtbits
        ply
        sta     [wrkbuf],y
        iny
        iny
        dec     temp2
        bne     makehuff2
        stz     hufcde
        lda     #$8000
        sta     hufbse
        lda     #1
        sta     bitlen
makehuff3       lda     bitlen
        ldx     temp1
        ldy     #0
makehuff4       cmp     [wrkbuf],y
        bne     makehuff8
        phx
        sty     temp3
        asl     a
        tax
        phb
        phk
        plb
        lda     msktab,x                ;>
        plb
        ldy     temp4
        sta     [wrkbuf],y
        iny
        iny
        lda     #16
        sec
        sbc     bitlen
        pha
        lda     hufcde
        sta     temp2
        ldx     bitlen
makehuff5       asl     temp2
        ror     a
        dex
        bne     makehuff5
        plx
        beq     makehuff7
makehuff6       lsr     a
        dex
        bne     makehuff6
makehuff7       sta     [wrkbuf],y
        iny
        iny
        sty     temp4
        tya
        clc
        adc     #(15*4)
        tay
        lda     bitlen
        xba
        sep     #$20    ; 8-bit accumulator
        lda     temp3
        lsr     a
        rep     #$21    ; 16-bit accumulator, clear carry
        sta     [wrkbuf],y
        lda     hufbse
        adc     hufcde
        sta     hufcde
        lda     bitlen
        ldy     temp3
        plx
makehuff8       iny
        iny
        dex
        bne     makehuff4
        lsr     hufbse
        inc     bitlen
        cmp     #16
        bne     makehuff3
        rts
.detect off

.mem 8

rnc_table:
        .dl set0        ; test
        .dl map0
        .dl col0

        .dl set6        ; 1943
        .dl map6
        .dl col6

;        .dl set45       ; 1999
;        .dl map45
;        .dl col45

        .dl set24       ; 720
        .dl map24
        .dl col24

        .dl set23       ; 8 Eyes
        .dl map23
        .dl col23

        .dl set49       ; Adventures of Dino Riki
        .dl map49
        .dl col49

        .dl set54       ; Adventure Island
        .dl map54
        .dl col54

        .dl set50       ; Adventures of Lolo
        .dl map50
        .dl col50

        .dl set51       ; Adventures of Lolo 2
        .dl map51
        .dl col51

        .dl set22       ; Adventures in the Magic Kingdom
        .dl map22
        .dl col22

        .dl set21       ; Air Fortress
        .dl map21
        .dl col21

        .dl set0        ; AIR - Kirameki
        .dl map0
        .dl col0

        .dl set0        ; AIR - Mikoto
        .dl map0
        .dl col0

        .dl set0        ; AIR - Wind
        .dl map0
        .dl col0

        .dl set7        ; Alfred Chicken
        .dl map7
        .dl col7

        .dl set55       ; Algus no Senshi
        .dl map55
        .dl col55

        .dl set28       ; Alien 3
        .dl map28
        .dl col28

        .dl set41       ; Alien Syndrome
        .dl map41
        .dl col41

        .dl set0        ; Altered Beast
        .dl map0
        .dl col0

        .dl set8        ; Al Unser Jr.
        .dl map8
        .dl col8

        .dl set26       ; Amagon
        .dl map26
        .dl col26

        .dl set58       ; America
        .dl map58
        .dl col58

        .dl set46       ; Antarctic Adventure
        .dl map46
        .dl col46

        .dl set34       ; Aressha
        .dl map34
        .dl col34

        .dl set13       ; Argus
        .dl map13
        .dl col13

        .dl set33       ; Arkanoid
        .dl map33
        .dl col33

        .dl set47       ; Arkanoid 2
        .dl map47
        .dl col47

        .dl set57       ; Armed Dragon Fantasy Villgust
        .dl map57
        .dl col57

        .dl set35       ; Asterix
        .dl map35
        .dl col35

;        .dl set39       ; Astro Robo
;        .dl map39
;        .dl col39

;        .dl set60       ; Astyanax
;        .dl map60
;        .dl col60

;        .dl set27       ; Athena
;        .dl map27
;        .dl col27

;        .dl set40       ; Atlantis
;        .dl map40
;        .dl col40
        
        .dl set25       ; Attack of the Killer Tomatoes
        .dl map25
        .dl col25

        .dl set0        ; Autumn Theme
        .dl map0
        .dl col0

        .dl set30       ; Bad Dudes
        .dl map30
        .dl col30

        .dl set29       ; Balloon Fight
        .dl map29
        .dl col29

        .dl set29       ; Balloon Fight VS (needs screenshot)
        .dl map29
        .dl col29

        .dl set59       ; Barbie
        .dl map59
        .dl col59

        .dl set434      ; Bart Meets Radioactive Man
        .dl map434
        .dl col434

        .dl set435      ; Bart vs The Space Mutants
        .dl map435
        .dl col435

        .dl set436      ; Bart vs The World
        .dl map436
        .dl col436

        .dl set422      ; Baseball Simulator 1.000
        .dl map422
        .dl col422

        .dl set37       ; Baseball Stars
        .dl map37
        .dl col37

        .dl set38       ; Baseball Stars 2
        .dl map38
        .dl col38

;        .dl set36       ; Batsu & Terii
;        .dl map36
;        .dl col36

;        .dl set63       ; Battle of Olympus
;        .dl map63
;        .dl col63

        .dl set32       ; Battle Toads
        .dl map32
        .dl col32

        .dl set31       ; Battle Toads and Double Dragon
        .dl map31
        .dl col31
        
        .dl set10       ; Bignose Freaks Out
        .dl map10
        .dl col10

        .dl set11       ; Bignose the Caveman
        .dl map11
        .dl col11

        .dl set0        ; Big Trouble in Baghdad
        .dl map0
        .dl col0

        .dl set61       ; Bikkuriman World
        .dl map61
        .dl col61

        .dl set14       ; Bionic Commando
        .dl map14
        .dl col14

;        .dl set15       ; Blaster Master
;        .dl map15
;        .dl col15

        .dl set16       ; Bokosuka Wars
        .dl map16
        .dl col16

        .dl set17       ; Bomberman
        .dl map17
        .dl col17

        .dl set62       ; Bonk's Adventure
        .dl map62
        .dl col62

        .dl set430      ; Booby Kids
        .dl map430
        .dl col430

        .dl set64       ; Bram Stoker's Dracula
        .dl map64
        .dl col64

        .dl set18       ; Break Thru
        .dl map18
        .dl col18

;        .dl set19       ; Bubble Bobble
;        .dl map19
;        .dl col19

        .dl set20       ; Bug Honey
        .dl map20
        .dl col20

        .dl set12       ; Bump 'n Jump
        .dl map12
        .dl col12

        .dl set9        ; Burai Fighter
        .dl map9
        .dl col9

        .dl set65       ; Burgertime
        .dl map65
        .dl col65

        .dl set42       ; B-Wings
        .dl map42
        .dl col42

        .dl set443      ; Caesar's Palace
        .dl map443
        .dl col443

        .dl set44       ; Captain America
        .dl map44
        .dl col44

;        .dl set43       ; Captain Tsubasa
;        .dl map43
;        .dl col43

        .dl set48       ; Castle Excellent
        .dl map48
        .dl col48

        .dl set2        ; Castlevania
        .dl map2
        .dl col2

        .dl set0        ; Caverns Boss
        .dl map0
        .dl col0

        .dl set53       ; Challenger
        .dl map53
        .dl col53

        .dl set56       ; Chaos World
        .dl map56
        .dl col56

        .dl set67       ; Chip and Dale
        .dl map67
        .dl col67

        .dl set68       ; Chip and Dale 2
        .dl map68
        .dl col68

        .dl set69       ; Choujen Sentai Jetman
        .dl map69
        .dl col69

        .dl set239      ; Chou Jikuu Macross
        .dl map239
        .dl col239

        .dl set66       ; Chousen
        .dl map66
        .dl col66

        .dl set70       ; Chugoku
        .dl map70
        .dl col70

        .dl set71       ; Circus Charlie
        .dl map71
        .dl col71

        .dl set72       ; City Connection
        .dl map72
        .dl col72

        .dl set74       ; Clash at Demonhead
        .dl map74
        .dl col74

        .dl set75       ; Cluclu Land
        .dl map75
        .dl col75

        .dl set75       ; Cluclu Land VS (needs screenshot, emu colors bad)
        .dl map75
        .dl col75

        .dl set76       ; Cobra Command
        .dl map76
        .dl col76

        .dl set73       ; Cobra Triangle
        .dl map73
        .dl col73

        .dl set79       ; Cocoron
        .dl map79
        .dl col79

        .dl set80       ; Codename: Viper
        .dl map80
        .dl col80

        .dl set78       ; Commando
        .dl map78
        .dl col78

        .dl set77       ; Conquest of the Crystal Palace
        .dl map77
        .dl col77

        .dl set81       ; Cool World
        .dl map81
        .dl col81

        .dl set82       ; Cosmo Police Galivan
        .dl map82
        .dl col82

        .dl set0        ; Covers vol.1
        .dl map0
        .dl col0

        .dl set83       ; Cowboy Kid
        .dl map83
        .dl col83

        .dl set345      ; Crazy Climber
        .dl map345
        .dl col345

        .dl set84       ; Daimash
        .dl map84
        .dl col84

;        .dl set85       ; Daisenryaku
;        .dl map85
;        .dl col85

        .dl set86       ; Daiva
        .dl map86
        .dl col86

;        .dl set0        ; Dance of the Sugarplum Fairies
;        .dl map0
;        .dl col0

        .dl set0        ; Dark City
        .dl map0
        .dl col0

        .dl set87       ; Darkwing Duck
        .dl map87
        .dl col87

        .dl set88       ; Dauntaun Nekketsu
        .dl map88
        .dl col88

;        .dl set89       ; DDS Megatensei
;        .dl map89
;        .dl col89

        .dl set414      ; Deadly Towers
        .dl map414
        .dl col414

        .dl set91       ; Deja Vu
        .dl map91
        .dl col91

        .dl set92       ; Destiny of an Emperor
        .dl map92
        .dl col92

        .dl set93       ; Destiny of an Emperor 2
        .dl map93
        .dl col93

        .dl set94       ; Devil World
        .dl map94
        .dl col94

        .dl set90       ; Disk System BIOS
        .dl map90
        .dl col90

        .dl set95       ; Dizzy the Adventurer
        .dl map95
        .dl col95

;        .dl set99       ; Dokuganryu
;        .dl map99
;        .dl col99

        .dl set100      ; Donald Duck
        .dl map100
        .dl col100

        .dl set101      ; Don Doko Don 2
        .dl map101
        .dl col101

        .dl set96       ; Donkey Kong
        .dl map96
        .dl col96

        .dl set98       ; Donkey Kong Jr.
        .dl map98
        .dl col98

        .dl set97       ; Donkey Kong 3
        .dl map97
        .dl col97

        .dl set102      ; Double Dragon
        .dl map102
        .dl col102

        .dl set103      ; Double Dragon 2
        .dl map103
        .dl col103

        .dl set104      ; Double Dragon 3
        .dl map104
        .dl col104

        .dl set445      ; Dragon Ball
        .dl map445
        .dl col445

        .dl set106      ; Dragon Ball 2
        .dl map106
        .dl col106

        .dl set105      ; Dragon Ball 3
        .dl map105
        .dl col105

        .dl set107      ; Dragon Buster
        .dl map107
        .dl col107

        .dl set108      ; Dragon Buster 2
        .dl map108
        .dl col108

        .dl set109      ; Dragon Fighter
        .dl map109
        .dl col109

        .dl set113      ; Dragon's Lair
        .dl map113
        .dl col113

        .dl set0        ; Dragon Slayer 4
        .dl map0
        .dl col0

        .dl set448      ; Dragon Spirit
        .dl map448
        .dl col448

        .dl set110      ; Dragon Unit
        .dl map110
        .dl col110

        .dl set300      ; Dragon Warrior
        .dl map300
        .dl col300

        .dl set301      ; Dragon Warrior 2
        .dl map301
        .dl col301

        .dl set302      ; Dragon Warrior 3
        .dl map302
        .dl col302

        .dl set111      ; Dr. Jeckyll
        .dl map111
        .dl col111

        .dl set112      ; Dropzone
        .dl map112
        .dl col112

        .dl set114      ; Duck Hunt
        .dl map114
        .dl col114

        .dl set115      ; Duck Hunt VS
        .dl map115
        .dl col115

        .dl set116      ; Duck Tales
        .dl map116
        .dl col116

        .dl set116      ; Duck Tales prototype
        .dl map116
        .dl col116

        .dl set117      ; Dungeon Magic
        .dl map117
        .dl col117

;        .dl set118      ; Elevator Action
;        .dl map118
;        .dl col118

        .dl set442      ; Elite
        .dl map442
        .dl col442

        .dl set415      ; Empire City
        .dl map415
        .dl col415

        .dl set119      ; Espabou
        .dl map119
        .dl col119

        .dl set0        ; Euphory Town
        .dl map0
        .dl col0

        .dl set120      ; Excitebike
        .dl map120
        .dl col120

        .dl set121      ; Excitebike VS
        .dl map121
        .dl col121

        .dl set122      ; F1 Race
        .dl map122
        .dl col122

        .dl set123      ; Famicom Tantei Club
        .dl map123
        .dl col123

        .dl set124      ; Family Circuit
        .dl map124
        .dl col124

        .dl set409      ; Family Mahjong
        .dl map409
        .dl col409

        .dl set125      ; Fantastic Adventures of Dizzy
        .dl map125
        .dl col125

        .dl set127      ; Fantasy Zone (Japan)
        .dl map127
        .dl col127

        .dl set126      ; Fantasy Zone
        .dl map126
        .dl col126

        .dl set128      ; Fantasy Zone 2
        .dl map128
        .dl col128

;        .dl set129      ; Faria
;        .dl map129
;        .dl col129

        .dl set130      ; Faxanadu
        .dl map130
        .dl col130

        .dl set138      ; Ferrari GP
        .dl map138
        .dl col138

        .dl set134      ; Fighting Golf
        .dl map134
        .dl col134

        .dl set131      ; Final Fantasy
        .dl map131
        .dl col131

        .dl set132      ; Final Fantasy 2
        .dl map132
        .dl col132

        .dl set133      ; Final Fantasy 3
        .dl map133
        .dl col133

        .dl set135      ; Firehawk
        .dl map135
        .dl col135

        .dl set0        ; Fix it with sticky tape
        .dl map0
        .dl col0

        .dl set136      ; Flappy
        .dl map136
        .dl col136

        .dl set137      ; Flintstones
        .dl map137
        .dl col137

        .dl set139      ; Freedom Force
        .dl map139
        .dl col139

        .dl set303      ; Friday the 13th
        .dl map303
        .dl col303

        .dl set0        ; Gallforce
        .dl map0
        .dl col0

        .dl set140      ; Gargoyle's Quest
        .dl map140
        .dl col140

        .dl set0        ; Garou Densetsu Special
        .dl map0
        .dl col0

        .dl set444      ; Gauntlet
        .dl map444
        .dl col444

        .dl set141      ; Gege
        .dl map141
        .dl col141

        .dl set142      ; Gekitotu
        .dl map142
        .dl col142

        .dl set143      ; Genpei
        .dl map143
        .dl col143

        .dl set144      ; Getsufuu Maden
        .dl map144
        .dl col144

        .dl set145      ; Goal 2
        .dl map145
        .dl col145

        .dl set146      ; Goemon
        .dl map146
        .dl col146

        .dl set147      ; Goldrunner
        .dl map147
        .dl col147

        .dl set148      ; Goonies
        .dl map148
        .dl col148

        .dl set149      ; Goonies 2
        .dl map149
        .dl col149

        .dl set150      ; Gorilla Man
        .dl map150
        .dl col150

;        .dl set151      ; Gotcha
;        .dl map151
;        .dl col151

        .dl set152      ; Gradius
        .dl map152
        .dl col152

        .dl set0        ; Greensleeves
        .dl map0
        .dl col0

        .dl set154      ; Guardian Legend
        .dl map154
        .dl col154

        .dl set155      ; Guerilla War
        .dl map155
        .dl col155

        .dl set156      ; Gun Smoke
        .dl map156
        .dl col156

        .dl set157      ; Halloween
        .dl map157
        .dl col157

        .dl set158      ; Hanjuku Hero
        .dl map158
        .dl col158

        .dl set159      ; Heavy Barrel
        .dl map159
        .dl col159

        .dl set160      ; Hector 87
        .dl map160
        .dl col160

        .dl set161      ; Heisei
        .dl map161
        .dl col161

        .dl set162      ; Hercules
        .dl map162
        .dl col162

        .dl set163      ; Hercules 2
        .dl map163
        .dl col163

        .dl set347      ; Hero Quest
        .dl map347
        .dl col347

        .dl set164      ; High Speed
        .dl map164
        .dl col164

        .dl set165      ; Hinotori
        .dl map165
        .dl col165

        .dl set166      ; Hogan's Alley
        .dl map166
        .dl col166

        .dl set167      ; Hogan's Alley (VS)
        .dl map167
        .dl col167

        .dl set439      ; Home Alone 2
        .dl map439
        .dl col439

        .dl set0        ; Homeland
        .dl map0
        .dl col0

        .dl set168      ; Hook
        .dl map168
        .dl col168
     
        .dl set169      ; Hudson Hawk
        .dl map169
        .dl col169

        .dl set170      ; Hyaku
        .dl map170
        .dl col170

        .dl set171      ; Hydlide
        .dl map171
        .dl col171

        .dl set172      ; Hydlide 3
        .dl map172
        .dl col172

        .dl set173      ; Hyper Olympic
        .dl map173
        .dl col173

        .dl set174      ; Hyper Sports
        .dl map174
        .dl col174

        .dl set175      ; Ice Climber
        .dl map175
        .dl col175

        .dl set176      ; Ice Climber FDS
        .dl map176
        .dl col176

        .dl set304      ; Ikari Warriors
        .dl map304
        .dl col304

        .dl set305      ; Ikari Warriors 2
        .dl map305
        .dl col305

        .dl set0        ; Ikaruga
        .dl map0
        .dl col0

        .dl set177      ; Ike Ike Ice Hockey
        .dl map177
        .dl col177

        .dl set410      ; Ikki
        .dl map410
        .dl col410

        .dl set0        ; I Love U
        .dl map0
        .dl col0

        .dl set178      ; Incredible Crash Test Dummies
        .dl map178
        .dl col178

        .dl set0        ; Indiana Jones Last Crusade
        .dl map0  
        .dl col0  

        .dl set180      ; Insector X
        .dl map180
        .dl col180

        .dl set153      ; Iron Tank
        .dl map153
        .dl col153

        .dl set181      ; Jackie Chan's Action Kung Fu
        .dl map181
        .dl col181

        .dl set182      ; James Bond Jr.
        .dl map182
        .dl col182

        .dl set183      ; Jetsons
        .dl map183
        .dl col183

        .dl set184      ; J-League
        .dl map184
        .dl col184

        .dl set185      ; Jungle Book
        .dl map185
        .dl col185

        .dl set186      ; Kabuki Quantum Fighter
        .dl map186
        .dl col186

        .dl set416      ; Kachiuma Densetsu
        .dl map416
        .dl col416

        .dl set0        ; Kai no Bouken (needs screenshot)
        .dl map0
        .dl col0

        .dl set187      ; Kamen Rider
        .dl map187
        .dl col187

        .dl set188      ; Karate Champ
        .dl map188
        .dl col188

        .dl set306      ; Karate Kid
        .dl map306
        .dl col306

        .dl set189      ; Karnov
        .dl map189
        .dl col189

        .dl set346      ; Kart Fighter
        .dl map346
        .dl col346

        .dl set0        ; K Demo 2
        .dl map0
        .dl col0

        .dl set417      ; Keiba Simulation
        .dl map417
        .dl col417

        .dl set190      ; Keru
        .dl map190
        .dl col190

        .dl set191      ; Kickle Cubicle
        .dl map191
        .dl col191

        .dl set429      ; Kid Icarus
        .dl map429
        .dl col429

        .dl set0        ; Kiken na Futari (needs screenshot)
        .dl map0
        .dl col0

        .dl set320      ; King Kong 2
        .dl map320
        .dl col320

        .dl set321      ; King's Knight
        .dl map321
        .dl col321

        .dl set192      ; Kiwi Kraze
        .dl map192
        .dl col192

        .dl set193      ; Klash Ball
        .dl map193
        .dl col193

        .dl set194      ; Krion Conquest
        .dl map194
        .dl col194

        .dl set195      ; Kung Fu
        .dl map195
        .dl col195

;        .dl set196      ; Labyrinth
;        .dl map196
;        .dl col196

        .dl set197      ; Lassalle
        .dl map197
        .dl col197

        .dl set198      ; Last Armageddon
        .dl map198
        .dl col198

;        .dl set199      ; Legacy of the Wizard
;        .dl map199
;        .dl col199

        .dl set200      ; Legendary Wings
        .dl map200
        .dl col200

;        .dl set201      ; Legend of Kage
;        .dl map201
;        .dl col201

        .dl set202      ; Legend of Zelda
        .dl map202
        .dl col202

        .dl set203      ; Lemmings
        .dl map203
        .dl col203

        .dl set204      ; Life Force
        .dl map204
        .dl col204

        .dl set205      ; Linus Spacehead
        .dl map205
        .dl col205

        .dl set206      ; Little Mermaid
        .dl map206
        .dl col206

        .dl set207      ; Little Nemo
        .dl map207
        .dl col207

        .dl set208      ; Little Samson
        .dl map208
        .dl col208

        .dl set209      ; Mach Rider
        .dl map209
        .dl col209

        .dl set210      ; Magic Darts
        .dl map210
        .dl col210

        .dl set211      ; Magic Johnson's Fast Break
        .dl map211
        .dl col211

        .dl set212      ; Magmax
        .dl map212
        .dl col212

        .dl set418      ; Mahjong
        .dl map418
        .dl col418

        .dl set213      ; Makaijima
        .dl map213
        .dl col213

        .dl set214      ; Mappy
        .dl map214
        .dl col214

        .dl set3        ; Marble Madness
        .dl map3
        .dl col3

        .dl set215      ; Mario Bros.
        .dl map215
        .dl col215

        .dl set238      ; Maze of Galious 2
        .dl map238
        .dl col238

        .dl set216      ; MC Kids
        .dl map216
        .dl col216

        .dl set217      ; Megaman
        .dl map217
        .dl col217

        .dl set218      ; Megaman 2
        .dl map218
        .dl col218

        .dl set219      ; Megaman 3
        .dl map219
        .dl col219

        .dl set220      ; Megaman 4
        .dl map220
        .dl col220

        .dl set221      ; Megaman 5
        .dl map221
        .dl col221

        .dl set222      ; Megaman 6
        .dl map222
        .dl col222

;        .dl set4        ; Metal Gear
;        .dl map4
;        .dl col4

        .dl set223      ; Micro Machines
        .dl map223
        .dl col223

        .dl set224      ; Mig 29 Soviet Fighter
        .dl map224
        .dl col224

        .dl set225      ; Might and Magic
        .dl map225
        .dl col225

        .dl set226      ; Mighty Bomb Jack
        .dl map226
        .dl col226

        .dl set227      ; Mighty Final Fight
        .dl map227
        .dl col227

        .dl set228      ; Mike Tyson's Punchout!!
        .dl map228
        .dl col228

        .dl set229      ; Milon's Secret Castle
        .dl map229
        .dl col229

        .dl set419      ; Mississippi Satsujin Jiken
        .dl map419
        .dl col419

        .dl set230      ; Mito Koumon
        .dl map230
        .dl col230

        .dl set420      ; Mizushima
        .dl map420
        .dl col420

        .dl set421      ; Moero Pro Yakyuu
        .dl map421
        .dl col421
        
        .dl set231      ; Moon Crystal
        .dl map231
        .dl col231

        .dl set0        ; Mouser        (needs screen)
        .dl map0
        .dl col0

        .dl set411      ; Muscle
        .dl map411
        .dl col411

        .dl set0        ; My Island Dream
        .dl map0
        .dl col0

        .dl set232      ; Nadia
        .dl map232
        .dl col232

        .dl set233      ; Nekketsu Koukou Dodgeball
        .dl map233
        .dl col233

        .dl set0        ; Neutopia
        .dl map0
        .dl col0

        .dl set412      ; NFL Football
        .dl map412
        .dl col412

        .dl set234      ; Nigel Mansell
        .dl map234
        .dl col234

        .dl set235      ; Nightmare on Elm Street
        .dl map235
        .dl col235

        .dl set236      ; Ninja Hattori
        .dl map236
        .dl col236

;        .dl set237      ; Ninja Kun
;        .dl map237
;        .dl col237

        .dl set240      ; Nuts and Milk
        .dl map240
        .dl col240

        .dl set241      ; Obake no Q
        .dl map241
        .dl col241

;        .dl set242      ; Ohotsuku
;        .dl map242
;        .dl col242

;        .dl set243      ; Onyanko Town
;        .dl map243
;        .dl col243

        .dl set244      ; Operation Wolf
        .dl map244
        .dl col244

        .dl set245      ; Over Horizon
        .dl map245
        .dl col245

        .dl set246      ; Overlord
        .dl map246
        .dl col246

        .dl set446      ; Pacmania
        .dl map446
        .dl col446

        .dl set247      ; Parasol Stars
        .dl map247
        .dl col247

        .dl set248      ; Pictionary
        .dl map248
        .dl col248

        .dl set249      ; Pinball
        .dl map249
        .dl col249

        .dl set250      ; Pinball VS
        .dl map250
        .dl col250

        .dl set251      ; Pizza Pop
        .dl map251
        .dl col251

        .dl set252      ; Platoon
        .dl map252
        .dl col252

        .dl set0        ; Po Barabanu
        .dl map0
        .dl col0

        .dl set0        ; Pocket Zaurus
        .dl map0
        .dl col0

;        .dl set253      ; Pocket Zaurus        ; crashes?
;        .dl map253
;        .dl col253

        .dl set254      ; Pooyan
        .dl map254
        .dl col254

        .dl set255      ; Popeye
        .dl map255
        .dl col255

        .dl set256      ; P.O.W.
        .dl map256
        .dl col256

;        .dl set257      ; Predator
;        .dl map257
;        .dl col257

        .dl set440      ; Prince of Persia
        .dl map440
        .dl col440

        .dl set258      ; Princess Tomato
        .dl map258
        .dl col258

;        .dl set259      ; Pro Wrestling
;        .dl map259
;        .dl col259

;        .dl set260      ; Puzznic
;        .dl map260
;        .dl col260

        .dl set0        ; Quattro Adventure Boomeraring Kid
        .dl map0
        .dl col0

        .dl set261      ; Quattro Adventure Linus Spacehead
        .dl map261
        .dl col261

        .dl set262      ; Quattro Adventure Robin Hood
        .dl map262
        .dl col262

        .dl set263      ; Quattro Adventure Treasure Island Dizzy
        .dl map263
        .dl col263

        .dl set264      ; Quattro Arcade CJ's Elephant
        .dl map264
        .dl col264

        .dl set265      ; Quattro Arcade F-16 Renegade
        .dl map265
        .dl col265

        .dl set266      ; Quattro Arcade Go Dizzy
        .dl map266
        .dl col266

        .dl set267      ; Quattro Arcade Stunt Buggies
        .dl map267
        .dl col267

        .dl set268      ; Quattro Sports Baseball
        .dl map268
        .dl col268

        .dl set0        ; Quattro Sports Soccer
        .dl map0
        .dl col0

        .dl set269      ; Radia
        .dl map269
        .dl col269

        .dl set270      ; Rad Racer
        .dl map270
        .dl col270

        .dl set271      ; Raid on Bungling Bay
        .dl map271
        .dl col271

        .dl set272      ; Rampage
        .dl map272
        .dl col272

        .dl set273      ; RBI Baseball
        .dl map273
        .dl col273

        .dl set274      ; RC ProAM
        .dl map274
        .dl col274

        .dl set275      ; RC ProAM 2
        .dl map275
        .dl col275

        .dl set433      ; Ren and Stimpy Show
        .dl map433
        .dl col433
        
        .dl set413      ; Renegade
        .dl map413
        .dl col413

        .dl set276      ; Rescue: The Embassy Mission
        .dl map276
        .dl col276

        .dl set277      ; River City Ransom
        .dl map277
        .dl col277

        .dl set278      ; Rmadillo
        .dl map278
        .dl col278

        .dl set279      ; Road Fighter
        .dl map279
        .dl col279

        .dl set280      ; Robocco Wars
        .dl map280
        .dl col280

        .dl set281      ; Robocop
        .dl map281
        .dl col281

        .dl set282      ; Robocop 2
        .dl map282
        .dl col282

        .dl set283      ; Robocop 3
        .dl map283
        .dl col283

        .dl set284      ; Robot Block
        .dl map284
        .dl col284

        .dl set285      ; Robot Gyro
        .dl map285
        .dl col285

        .dl set286      ; Robowarrior
        .dl map286
        .dl col286

        .dl set287      ; Rockin' Kats
        .dl map287
        .dl col287

        .dl set288      ; Roller Ball
        .dl map288
        .dl col288

        .dl set289      ; Romancia
        .dl map289
        .dl col289

        .dl set0        ; Romancing Saga 1_8
        .dl map0
        .dl col0

        .dl set0        ; Romancing Saga 1_10
        .dl map0
        .dl col0

        .dl set0        ; Romancing Saga 1_11
        .dl map0
        .dl col0

        .dl set0        ; Romancing Saga 1_14
        .dl map0
        .dl col0

        .dl set0        ; Romancing Saga 2_3
        .dl map0
        .dl col0

        .dl set0        ; Rophon's Theme
        .dl map0
        .dl col0

        .dl set0        ; Ropm 2001/9/29
        .dl map0
        .dl col0

        .dl set0        ; Ropm 2002/6/11
        .dl map0
        .dl col0

        .dl set290      ; Route 16
        .dl map290
        .dl col290

        .dl set291      ; Rush 'n Attack
        .dl map291
        .dl col291

        .dl set292      ; Rygar
        .dl map292
        .dl col292

        .dl set447      ; Saint Sei
        .dl map447
        .dl col447

        .dl set293      ; Sanma
        .dl map293
        .dl col293

;        .dl set0        ; SD Keiji Blader
;        .dl map0
;        .dl col0

        .dl set294      ; Section Z
        .dl map294
        .dl col294

        .dl set0        ; Shadowed: Grass
        .dl map0
        .dl col0

        .dl set295      ; Shadowgate
        .dl map295
        .dl col295

        .dl set296      ; Shadow of the Ninja
        .dl map296
        .dl col296

        .dl set297      ; Shancara
        .dl map297
        .dl col297

        .dl set298      ; Shanghai
        .dl map298
        .dl col298

        .dl set359      ; Shatterhand
        .dl map359
        .dl col359

        .dl set299      ; Shen Huo
        .dl map299
        .dl col299

        .dl set0        ; Shikinjou (needs screenshot)
        .dl map0
        .dl col0

        .dl set0        ; Shinjuku (needs screenshot)
        .dl map0
        .dl col0

        .dl set307      ; Shinobi
        .dl map307
        .dl col307

        .dl set319      ; Shooting Range
        .dl map319
        .dl col319

        .dl set308      ; Shoukoushi Ceddie
        .dl map308
        .dl col308

        .dl set424      ; Side Pocket
        .dl map424
        .dl col424

        .dl set309      ; Silver Surfer
        .dl map309
        .dl col309

        .dl set310      ; Sky Kid
        .dl map310
        .dl col310

        .dl set311      ; Sky Shark
        .dl map311
        .dl col311

        .dl set312      ; Smurfs
        .dl map312
        .dl col312

        .dl set313      ; Snow Bros.
        .dl map313
        .dl col313

        .dl set314      ; Soccer
        .dl map314
        .dl col314

        .dl set315      ; Solar Jetman
        .dl map315
        .dl col315

        .dl set316      ; Solomon's Key
        .dl map316
        .dl col316

        .dl set317      ; Solstice
        .dl map317
        .dl col317

        .dl set318      ; Somari
        .dl map318
        .dl col318

        .dl set0        ; Soshite
        .dl map0
        .dl col0

        .dl set431      ; Space Harrier
        .dl map431
        .dl col431

        .dl set322      ; Space Shadow
        .dl map322
        .dl col322

        .dl set0        ; Space Shuttle
        .dl map0
        .dl col0

        .dl set323      ; Spartan X 2
        .dl map323
        .dl col323

        .dl set324      ; Spelunker
        .dl map324
        .dl col324
                
        .dl set325      ; Spiderman
        .dl map325
        .dl col325

        .dl set326      ; Splatterhouse
        .dl map326
        .dl col326

        .dl set327      ; Spy Hunter
        .dl map327
        .dl col327

;        .dl set328      ; Star Force (J)
;        .dl map328
;        .dl col328

        .dl set329      ; Star Force
        .dl map329
        .dl col329

        .dl set330      ; Star Luster
        .dl map330
        .dl col330

        .dl set331      ; Star Soldier
        .dl map331
        .dl col331

        .dl set437      ; Star Trek - The Next Generation
        .dl map437
        .dl col437

        .dl set332      ; Star Tropics 2
        .dl map332
        .dl col332

        .dl set333      ; Sted
        .dl map333
        .dl col333

        .dl set334      ; Stinger
        .dl map334
        .dl col334

        .dl set335      ; Street Fighter 2010
        .dl map335
        .dl col335

        .dl set336      ; Strider
        .dl map336
        .dl col336

        .dl set5        ; Super Mario Bros. 2
        .dl map5
        .dl col5

        .dl set337      ; Super Star Force
        .dl map337
        .dl col337

        .dl set338      ; Super Xevious
        .dl map338
        .dl col338

        .dl set438      ; Swamp Thing
        .dl map438
        .dl col438
        
        .dl set339      ; Sweet Home
        .dl map339
        .dl col339

        .dl set340      ; Swords and Serpents
        .dl map340
        .dl col340

        .dl set341      ; Tag Team Wrestling
        .dl map341
        .dl col341

        .dl set342      ; Taito GP
        .dl map342
        .dl col342

;        .dl set343      ; Takeshi
;        .dl map343
;        .dl col343

        .dl set432      ; TaleSpin
        .dl map432
        .dl col432

        .dl set344      ; Target Renegade
        .dl map344
        .dl col344

        .dl set348      ; Tecmo Soccer
        .dl map348
        .dl col348

        .dl set349      ; Tecmo Cup
        .dl map349
        .dl col349

        .dl set350      ; Tecmo World Wrestling
        .dl map350
        .dl col350

        .dl set356      ; Terminator 2
        .dl map356
        .dl col356

        .dl set449      ; Terra Cresta (J)
        .dl map449
        .dl col449

        .dl set355      ; Terra Cresta
        .dl map355
        .dl col355

;        .dl set351      ; Tetris (BPS)
;        .dl map351
;        .dl col351

        .dl set352      ; Tetris
        .dl map352
        .dl col352

        .dl set353      ; Tetris (Tengen)
        .dl map353
        .dl col353

;        .dl set354      ; Tetris Flash
;        .dl map354
;        .dl col354

;        .dl set357      ; Tiger Heli
;        .dl map357
;        .dl col357

        .dl set358      ; Time Zone
        .dl map358
        .dl col358

        .dl set425      ; Tokaido 53 Tsugi
        .dl map425
        .dl col425

        .dl set360      ; Tom and Jerry
        .dl map360
        .dl col360

        .dl set361      ; Tombs and Treasures
        .dl map361
        .dl col361

        .dl set362      ; Top Striker
        .dl map362
        .dl col362

;        .dl set363      ; Totally Rad
;        .dl map363
;        .dl col363

        .dl set441      ; Total Recall
        .dl map441
        .dl col441

        .dl set364      ; Touch Down Fever
        .dl map364
        .dl col364

        .dl set365      ; Toukon Club
        .dl map365
        .dl col365

        .dl set366      ; Tower of Babel
        .dl map366
        .dl col366

        .dl set408      ; Tower of Druaga
        .dl map408
        .dl col408

        .dl set367      ; Toxic Crusaders
        .dl map367
        .dl col367

        .dl set423      ; Transformer Convoy no Nazo
        .dl map423
        .dl col423

        .dl set368      ; Treasure Master
        .dl map368
        .dl col368

        .dl set369      ; Trojan
        .dl map369
        .dl col369

        .dl set370      ; Tsuppari
        .dl map370
        .dl col370

        .dl set371      ; Twinbee
        .dl map371
        .dl col371

        .dl set372      ; Ultima Exodus
        .dl map372
        .dl col372

;        .dl set373      ; Ultima 2
;        .dl map373
;        .dl col373

        .dl set374      ; Uncharted Waters
        .dl map374
        .dl col374

        .dl set375      ; Uninvited
        .dl map375
        .dl col375

        .dl set376      ; Urban Champion
        .dl map376
        .dl col376

        .dl set0        ; Ushio to Tora (needs screenshot)
        .dl map0
        .dl col0

        .dl set0        ; Valkyrie no Bouken
        .dl map0
        .dl col0

        .dl set377      ; V'ball
        .dl map377
        .dl col377

        .dl set378      ; Venus Senki
        .dl map378
        .dl col378

        .dl set379      ; Vice: Project Doom
        .dl map379
        .dl col379

        .dl set380      ; Volgard
        .dl map380
        .dl col380

;        .dl set52       ; Wacky Races
;        .dl map52
;        .dl col52

        .dl set381      ; Wagan Land
        .dl map381
        .dl col381

        .dl set427      ; Wagan Land 2
        .dl map427
        .dl col427

        .dl set426      ; Wild Gunman
        .dl map426
        .dl col426

        .dl set382      ; Willow
        .dl map382
        .dl col382

        .dl set383      ; Wily and Rockman Boardgame
        .dl map383
        .dl col383

        .dl set0        ; Winglancer Area 1
        .dl map0
        .dl col0

        .dl set0        ; Winglancer Area 2
        .dl map0
        .dl col0

        .dl set0        ; Winglancer Area 3
        .dl map0
        .dl col0

        .dl set0        ; Winglancer Area 4
        .dl map0
        .dl col0

        .dl set0        ; Winglancer Area 5
        .dl map0
        .dl col0

        .dl set0        ; Winglancer Boss 1
        .dl map0
        .dl col0

        .dl set0        ; Winglancer Boss 2
        .dl map0
        .dl col0

        .dl set0        ; Winglancer Boss Mode
        .dl map0
        .dl col0

        .dl set384      ; Wizardry
        .dl map384
        .dl col384

        .dl set385      ; Wizardry 2
        .dl map385
        .dl col385

        .dl set386      ; Wizardry 3
        .dl map386
        .dl col386

        .dl set387      ; Wizards and Warriors
        .dl map387
        .dl col387

        .dl set388      ; Wizards and Warriors 2
        .dl map388
        .dl col388

        .dl set389      ; Wizards and Warriors 3
        .dl map389
        .dl col389

        .dl set390      ; Wolverine
        .dl map390
        .dl col390

        .dl set391      ; World Champ
        .dl map391
        .dl col391

        .dl set428      ; Wrecking Crew
        .dl map428
        .dl col428

        .dl set428      ; Wrecking Crew VS
        .dl map428
        .dl col428

        .dl set392      ; Wurm
        .dl map392
        .dl col392

        .dl set393      ; WWF Wrestlemania
        .dl map393
        .dl col393

        .dl set394      ; WWF Wrestlemania Challenge
        .dl map394
        .dl col394

        .dl set0        ; Xenon
        .dl map0
        .dl col0

        .dl set395      ; Xenophobe
        .dl map395
        .dl col395

;        .dl set396      ; Xexyz
;        .dl map396
;        .dl col396

        .dl set397      ; Yie-Ar Kung Fu
        .dl map397
        .dl col397

        .dl set398      ; Yo Noid
        .dl map398
        .dl col398

        .dl set399      ; Yoshi's Cookie
        .dl map399
        .dl col399

        .dl set400      ; Ys
        .dl map400
        .dl col400

        .dl set401      ; Ys 2
        .dl map401
        .dl col401

        .dl set402      ; Ys 3
        .dl map402
        .dl col402

        .dl set0        ; Ys POD
        .dl map0
        .dl col0

        .dl set403      ; Yuu Maze
        .dl map403
        .dl col403

        .dl set0        ; Yuu Yuu Hakusho
        .dl map0
        .dl col0

        .dl set404      ; Zanac
        .dl map404
        .dl col404

        .dl set405      ; Zelda 2
        .dl map405
        .dl col405

        .dl set0        ; Zelda end
        .dl map0
        .dl col0

        .dl set406      ; Zeta Gundam
        .dl map406
        .dl col406

        .dl set407      ; Zombie Hunter
        .dl map407
        .dl col407

        .dl set0        ; Dummy screen
        .dl map0
        .dl col0



colortest:
testcol:        
;        .incbin "romtest.col"

bitfont:
;testset:        
testset = $7EA000        

;        .incbin "romtest.set"
;        .incbin "snes2.chr"


;phont:  .incbin "snes2.chr"
phont2: .incbin "ascii.bin"


bitmap:

testmap = $7EE000

freq_table:     .incbin "freq.bin"
vispal:         .include "vispal.asm"

nescode:
.base $7F5000
nesrun:
        jmp nesplay
        jmp nesinit
        jmp nestest
nesinit:
        php
        phk        
        plb
        pha
.mem 16
        rep #$20
        lda.w #$0000
        tcd
.mem 8
.index 8       
        sep #$30        ; mem and index to 8-bit

        pla

        sec
        xce             ; 6502 mode


        ldx #0
        txy

        jsr ($1013,x)

;        jsr $7F8800

        sei
        clc
        xce             ; native mode
.mem 16
        rep #$20
        lda.w #$1000
        tcd
.mem 8
        sep #$20

        lda #$0F
        sta $7F4015

        plp             

        rtl
nesplay:
        php
        phk
        plb

.mem 16
        rep #$20
        lda.w #$0000
        tcd
.mem 8
.index 8
        sep #$30
        
        sec
        xce             ; 6502 mode

        ldx #0
        txy
        jsr ($1015,x)

;        jsr $7F8000
        
        sei
        clc
        xce             ; native mode

.mem 16
        rep #$20
        lda.w #$1000
        tcd
.mem 8
        sep #$20
        
        plp
                
        rtl

nestest:
        rtl

.end                    ; end code in RAM


crash:
        stz $2121
        lda #$FF
        sta $2122
        sta $2122
crashed:
;        jmp start
        nop
        bra crashed


.dasm off

.cart
        title   = "NES Sound Emulator   "
        mode    = $31   ; low + fastrom
        type    = $02
        romsize = $0C
        ramsize = $05
        country = $01
        maker   = $00
        version = $01
.end

.interrupts
        all     = empty
        nmi     = vblanknmi
        reset   = start
        break   = crash
        coproc  = empty
        irq     = h_irq
.end

.pad $C0FE00

psine1:         .include "64sin720.txt"
;psine2:         .include "64sine.txt"
;psine3:         .include "psine3.txt"


.pad
jml $C00000

scrolltext:


.db     "-=- SNES 2A03 Emulator -=-                     "
.db     "Press start to continue, or stick around for more info . . . .            "
.db     "- Instructions -     "         "
.db     "Selection Menu;  Start = load NSF       Select = exit menu       "
.db     "Up and Down = cycle through list       Left and Right = skip pages       "
.db     "View Mode;  A and X = cycle through view modes       Up and Down = "
.db     "cycle through songs       Left and Right = previous/next NSF       "
.db     "Y = toggle stereo/mono       "
.db     "R and L = slow down/speed up song        "
.db     "Select = NSF load menu       Start = restart song       "
.db     " . . . . .             "
.db     "- Program Credits -      "
.db     "-=Design and Programming=-  - Memblers      "
.db     "-=Technical Assisstance=- - Kevin Horton      "
.db     "-=NSF Logo=- - d4s/science      "
.db     "-=Intro Music=- - 'Exploder' by Paul van der Valk, NES version by Chibi-Tech      "
.db     "-=Intro Music Engine=- - Bananmos      "
.db     "-=Font=- - Bnu_      "
.db     "-=NES Sound Documentation=- - Brad Taylor      "
.db     "-=SNES Documentation=- - Jeremy Chadwick      "
.db     "-=SPC-700 Documentation=- - LEDI and Antitrack      "
.db     " . . . .      "
.db     "- Utility Credits -      "
.db     "NSFTool - TNSe      "
.db     "PRO-PACK - Rob Northen      "
.db     "Pictview - Jan Patera      "
.db     "PSX2SOPT - Paul      "
.db     "FCE Ultra - Bero, Xod, and ??      "
.db     "NESticle - Bloodlust Software      "
.db     "zSNES - zsKnight, _Demo_, and Pharos      "
.db     " . . . .      "
.db     "-=Testing=- - Siudym & d4s     "
.db     " . . . .      "
.db     "-=Special Thanks=- - Lik Sang     "
.db     " .  .   .    .     .      .                "
.db     "Released March 3rd, 2003.                   "
.db     "I was thinking I'd write some greetings here, but I won't.  "
.db     "We would be here all day.  I've met so many interesting "
.db     "people from all over the world.       But I must give credit to "
.db     "the following people, as this program couldn't have been made without the NSF "
.db     "creation work done by them    -  "
.db     "Ryan Novak - Minachun - necrosaro - "
.db     "Scott Worley - Manbow-J - Chris Covell - Neill Corlett - myu2203 - "
.db     "din mamma - Mk-II - Gil_Galad - wombatman - Izumi - Gigandes - "
.db     "TNSe - Mike Blum - Kevin Horton - Vigo - loopy - Daniel Kalabakov - "
.db     "Ben Parnell - fukui.cat - Damian Yerrick - doppelganger - TFLthuG - "
.db     "Spinner_8 - Mao - YY - Phlum-Dumb - Dober - Chris Moeller - UENO - "
.db     "JPD002 - Matt Conte - Mamiya - ZYX - Quietust - and anyone I missed - "
.db     "everyone using MML and NT2, making new music     "
.db     "                                       "
.db     "That's about it.     "
.db     "                                       "
.db     "Since you've sat through all this, I might as well tell you "
.db     "how this whole thing started.  Sometime around June 2001 my PC stopped working.  "
.db     "So I was messing around with my SNES Gamestation (thanks to Lik-Sang), "
.db     "and was thinking that it would be nice to have some music to listen "
.db     "to..  I had a 386 laptop borrowed from a friend, equipped with "
.db     "only Win3.11, Trumpet winsock, and mIRC, I jumped on the net and "
.db     "grabbed some SNES dev tools.  It was easy to do most of the programming, "
.db     "since I already knew 6502 assembly.  What it does, is copy the NES "
.db     "code into RAM and run it as-is.  It has it's own 64KB bank of memory "
.db     "to play with, and there are no side effects unless the code abuses the zero-page.  "
.db     "And some of them did.  Severely.  Most were eventually patched, others are beyond help.  "
.db     "There's still some odd ones that didn't work for other reasons, and "
.db     "a smaller number that didn't because of design limitations with my "
.db     "'emulation' (Marble Madness is one).  Anyways, the CPU part was easy.  "
.db     "When I got to the sound emulation phase, I got some assistance from "
.db     "the unstoppable kevtris in getting the playback frequencies exactly "
.db     "how they should be.  I had a working NSF player on my hands.  I started "
.db     "writing better code for the SPC-700, using it's timers to get "
.db     "a close-enough-for-me emulation of the sweep and volume envelope "
.db     "features.  All that was left was to organize and compress everything, "
.db     "and throw in some extra features like MOD-player style info display, "
.db     "a keyboard view, etc.  The program languished on my disk for some time "
.db     "before it got to the point where it is now, and not everything was done "
.db     "in the order I listed them in.  But, what was the reason my PC "
.db     "quit working, triggering this chain of events?  Only because it's CPU "
.db     "had came loose from the socket.  It was pushed back in, and was working "
.db     "fine minutes later.  What a trip.       "
.db     "                               "
.db     "OK, that's the end of this scroll-text.    -   .   -               "
.db     "Now go listen to some music or something               "
.db     "                                       "
.db     "                                       "
.db     "                                       "
.db     $00

nsf_list:      .include "nsflist.asm"

.db     " All trademarks and copyrights are properties of their respective owners.  "
.db     "  Used on a strictly non-profit basis.  "
.db     "                 "
.db     "                               "

spiralmap: .incbin "pcx\spiral.map"
spiralset: .incbin "pcx\spiral.set"
spiralcol: .incbin "pcx\spiral.col"

sinex:  .include "sinex.txt"


replay22:   ;            .incbin "replay22.rnc"

intro_nsf:              .incbin "exploder.nsf"
intro_nsf_end:



;.include "sound.asm"

volume_block_table:
vol0: .dw $0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol1: .dw $0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol2: .dw $0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol3: .dw $0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol4: .dw $0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol5: .dw $0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol6: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol7: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol8: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0480,$0480,$0480,$0480,$0480,$0480,$0480,$0480
vol9: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0480,$0480,$0480,$0480,$0480,$0480,$0480
volA: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0480,$0480,$0480,$0480,$0480,$0480
volB: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0480,$0480,$0480,$0480,$0480
volC: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0480,$0480,$0480,$0480
volD: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0483,$0480,$0480,$0480
volE: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0483,$0483,$0480,$0480
volF: .dw $0481,$0481,$0481,$0481,$0481,$0481,$0481,$0481,$0482,$0482,$0482,$0482,$0483,$0483,$0483,$0480


;===============
;Graphics by d4s
;===============

interface_map:  .incbin "gfx/interf~2.map"
interface_set:  .incbin "gfx/interf~2.set"
interface_col:  .incbin "gfx/interf~2.col"



;=========================================
;       interface design by d4s
;=========================================

d4s_mode:
                                ; VRAM map
                                ; $0000-$1FFF BG1 map
                                ; $2000-$3FFF BG2 map
                                ; $4000-$4800 BG3 tiles
                                ; $5000-$???? BG3 map
                                ; $8000-$BFFF BG1 tiles
                                ; $C000-$FFFF BG2 tiles

        stz status
        lda #$80
        sta $2100
        stz $212C

        lda #$00
        sta $2107       ; BG1 map
        lda #$20
        sta $2108       ; BG2 map
        lda #$C0
        sta $210B       ; BG1/BG2 tiles


                                ; DMA all this to VRAM..
        ldx.w #$0000
        stx $2116
        lda #1
        sta $4300
        lda #$18
        sta $4301
        ldx.w #interface_map&$FFFF
        stx $4302
        lda #interface_map/$10000
        sta $4304
        ldx.w #$2000
        stx $4305
        lda #1
        sta $420B

        ldx.w #$8000
        stx $2116
        lda #1
        sta $4300
        lda #$18
        sta $4301
        ldx.w #interface_set&$FFFF
        stx $4302
        lda #interface_set/$10000
        sta $4304
        ldx.w #$4000
        stx $4305
        lda #1
        sta $420B


        lda #$00
        sta $2121               ; write palette
        ldx.w #0
-
        lda interface_col,x
        sta $2122
        inx
        cpx #32
        bne -



        lda #$0F
        sta $2100

        lda #%10000001  ; enable controller and NMI
        sta $4200

        lda #%00001001  ; mode 1 with highest priority for BG3
        sta $2105
        
        lda #%00010111  ; screen enable
        sta $212C



testhalt:
        jmp testhalt





.pad

Picture:

;========================================
.db   "Graphic data"
;========================================

.include "gfx.asm"
;.include "gfx-non.asm"


;========================================
.db "NSF data"          ; file addr and load addr - NSF header
;========================================

.pad

;.include "skimpy.asm"
.include "full-hi.asm"

.pad
